% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{matchBytes}
\alias{matchBytes}
\title{Locate Byte Sequences in a Raw Vector}
\usage{
matchBytes(input, b1, ...)
}
\arguments{
\item{input}{a vector of raw (byte) values.}

\item{b1}{a vector of bytes to match (must be of length 2 or 3 at present;
for 1-byte, use \code{\link[=which]{which()}}).}

\item{\dots}{additional bytes to match for (up to 2 permitted)}
}
\value{
\code{matchBytes} returns a double vector of the indices of \code{input} that
match the start of the \code{bytes} sequence.  (A double vector is returned
instead of an integer vector, to avoid problems with large files.)
}
\description{
Find spots in a raw vector that match a given byte sequence.
}
\examples{
buf <- as.raw(c(0xa5, 0x11, 0xaa, 0xa5, 0x11, 0x00))
print(buf)
print(matchBytes(buf, 0xa5, 0x11))

}
\author{
Dan Kelley
}
