% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnegocc.R, R/dnegocc.all.R, R/pnegocc.R,
%   R/qnegocc.R, R/rnegocc.R
\name{dnegocc}
\alias{dnegocc}
\alias{dnegocc.all}
\alias{pnegocc}
\alias{qnegocc}
\alias{rnegocc}
\title{The Negative Occupancy Distribution}
\usage{
dnegocc(x, space, occupancy, prob = 1, approx = FALSE, log = FALSE)

dnegocc.all(max.x, space, max.occupancy, prob = 1, approx = FALSE, log = FALSE)

pnegocc(
  x,
  space,
  occupancy,
  prob = 1,
  approx = FALSE,
  log.p = FALSE,
  lower.tail = TRUE
)

qnegocc(
  p,
  space,
  occupancy,
  prob = 1,
  approx = FALSE,
  log.p = FALSE,
  lower.tail = TRUE
)

rnegocc(n, space, occupancy, prob = 1)
}
\arguments{
\item{x}{vector of quantiles.}

\item{space}{The space parameter for the negative occupancy distribution (number of bins)}

\item{occupancy}{The occupancy parameter for the negative occupancy distribution (number of occupied bins)}

\item{prob}{The probability parameter for the negative occupancy distribution (probability of ball occupying its bin)}

\item{approx}{A logical value specifying whether to use an approximation for the distribution}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{max.x}{A vector of numeric values to be used as arguments for the mass function}

\item{max.occupancy}{The maximum occupancy parameter for the negative occupancy distribution (number of occupied bins)}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
If all inputs are correctly specified (i.e., parameters are in allowable range and arguments are integers)
then the output will be a matrix of probabilities/log-probabilities
}
\description{
Density, distribution function, quantile function and random generation
for the negative occupancy distribution with space and occupancy parameters.
}
\details{
\code{dnegcount.all} returns the entire PMF.

The computation method uses a recursive algorithm described in the reference.
}
\section{References}{


O'Neill, B. (2021) An examination of the negative-occupancy distribution and the coupon-collector distribution.
}

\examples{
x <- rnegocc(10, 2, 2)
p <- pnegocc(x, 2, 2)
qnegocc(0:9/10, 2, 2)
dnegocc.all(5,2,2)
}
