% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_si.R
\name{get_si}
\alias{get_si}
\title{Compute the serial interval (si) from transmission trees}
\usage{
get_si(
  trees,
  date_suffix = "date",
  stats = list(mean = mean, lwr = function(x) quantile(x, 0.025, na.rm = TRUE), upr =
    function(x) quantile(x, 0.975, na.rm = TRUE))
)
}
\arguments{
\item{trees}{A list of data frames, generated by \code{\link{get_trees}}.
It should contain information about the dates of onset.}

\item{date_suffix}{A string indicating the suffix for date of onset columns.
Default is "date", which means the columns should be named \code{from_date} and \code{to_date}.}

\item{stats}{A list of functions to compute statistics. Default is:
\itemize{
\item \code{mean}: the mean serial interval.
\item \code{lwr}: the 2.5th percentile (lower quantile).
\item \code{upr}: the 97.5th percentile (upper quantile).
}
Each function should take a numeric vector as input and return a single numeric value.}
}
\value{
A data frame with serial interval statistic
}
\description{
The serial interval is the time between the onset of symptoms in an infector-infectee pair.
This function computes the serial interval statistics from a list of transmission trees.
}
\examples{
trees <- get_trees(out, date = linelist$onset)
si_stats <- get_si(trees)
str(si_stats)

}
\seealso{
\code{\link{get_trees}} for generating a list of transmission trees.
}
