% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressionFromAttributeValue.R
\name{expressionFromAttributeValue}
\alias{expressionFromAttributeValue}
\title{Generates a query expression for matching a single-value transcript/participant
attribute, for use with \link{getMatches}}
\usage{
expressionFromAttributeValue(transcript.attribute, values, not = FALSE)
}
\arguments{
\item{transcript.attribute}{The transcript attribute to filter by.}

\item{values}{A list of possible values for transcript.attribute.}

\item{not}{Whether to match the given IDs (FALSE), or everything \emph{except} the
given IDs.}
}
\value{
A transcript query expression which can be passed as the
transcript.expression parameter of \link{getMatches} or the expression parameter
of \link{getMatchingTranscriptIds}
}
\description{
This function generates a query expression fragment which can be passed as
the transcript.expression or participant.expression parameter of \link{getMatches}, (or
the expression parameter of \link{getMatchingTranscriptIds} or
\link{getMatchingParticipantIds}) using a list of possible values for a given
attribute.
}
\details{
The attribute defined by transcript.attribute is expected to have exactly one value. If
it may have multiple values, use \link{expressionFromAttributeValues} instead.
}
\examples{
\dontrun{
## Perform a search
languages <- c("en","en-NZ")
results <- getMatches(labbcat.url, list(segment="I"),
                      transcript.expression = expressionFromAttributeValue(
                            "transcript_language", languages))
}
}
\seealso{
\itemize{
\item \link{expressionFromAttributeValues}
\item \link{expressionFromTranscriptTypes}
\item \link{expressionFromIds}
\item \link{getMatches}
}
}
\keyword{search}
