% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsp_poly.R
\name{nsp_poly}
\alias{nsp_poly}
\title{Narrowest Significance Pursuit algorithm for piecewise-polynomial signals}
\usage{
nsp_poly(
  y,
  M = 1000,
  thresh.type = "univ",
  thresh.val = NULL,
  sigma = NULL,
  alpha = 0.1,
  deg = 0,
  overlap = FALSE
)
}
\arguments{
\item{y}{A vector containing the data sequence.}

\item{M}{The minimum number of intervals considered at each recursive stage, unless the number of all intervals is smaller, in which case all intervals
are used.}

\item{thresh.type}{\code{"univ"} if the significance threshold is to be determined as in Kabluchko (2007); \code{"sim"} for the degree-dependent
threshold determined
by simulation (this is only available if the length of \code{y} does not exceed 2150; for longer sequences obtain a suitable threshold by running
\code{cov_dep_multi_norm_poly} first).}

\item{thresh.val}{Numerical value of the significance threshold (lambda in the paper); or \code{NULL} if the threshold is to be determined from
the data (see \code{thresh.type}).}

\item{sigma}{The standard deviation of the errors z_t; if \code{NULL} then will be estimated from the data via Median Absolute Deviation (for i.i.d.
Gaussian sequences) of the first difference.}

\item{alpha}{Desired maximum probability of obtaining an interval that does not contain a change-point (the significance threshold will be
determined as a function of this parameter).}

\item{deg}{The degree of the polynomial pieces in f_t (0 for the piecewise-constant model; 1 for piecewise-linearity, etc.).}

\item{overlap}{If \code{FALSE}, then on discovering a significant interval, the search continues recursively to the left and to the right of that
interval. If \code{TRUE}, then the search continues to the left and to the right of the midpoint of that interval.}
}
\value{
A list with the following components:
\item{intervals}{A data frame containing the estimated intervals of significance: \code{starts} and \code{ends} is where the intervals start and end,
respectively; \code{values} are the values of the deviation measure on each given interval; \code{midpoints} are their midpoints.}
\item{threshold.used}{The threshold value.}
}
\description{
This function runs the Narrowest Significance Pursuit (NSP) algorithm on a data sequence \code{y} believed to follow the model
y_t = f_t + z_t, where f_t is a piecewise polynomial of degree \code{deg}, and z_t is noise. It returns localised regions (intervals) of the
domain, such that each interval must contain a change-point in the parameters of the polynomial f_t
at the global significance level \code{alpha}.
For any interval considered by the algorithm,
significant departure from parameter constancy is achieved if the multiscale supremum-type
deviation measure (see Details for the literature reference) exceeds a threshold, which is either provided as input
or determined from the data (as a function of \code{alpha}). The function works best when the errors z_t are independent and
identically distributed Gaussians.
}
\details{
The NSP algorithm is described in P. Fryzlewicz (2021) "Narrowest Significance Pursuit: inference for multiple change-points in linear
models", preprint. For how to determine the \code{"univ"} threshold, see Kabluchko, Z. (2007) "Extreme-value analysis of standardized Gaussian increments".
Unpublished.
}
\examples{
set.seed(1)
f <- c(1:100, 100:1, 1:100)
y <- f + stats::rnorm(300) * 15
nsp_poly(y, 100, deg = 1)
}
\seealso{
\code{\link{nsp}}, \code{\link{nsp_poly_ar}}, \code{\link{nsp_tvreg}}, \code{\link{nsp_selfnorm}}, \code{\link{nsp_poly_selfnorm}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
