% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_select.R
\name{nest_select}
\alias{nest_select}
\title{Subset columns in nested data frames using their names and types}
\usage{
nest_select(.data, .nest_data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{One or more unquoted expressions separated by commas. Variable
names can be used if they were positions in the data frame, so expressions
like \code{x:y} can be used to select a range of variables.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will also be of the same type as the input. Each object in \code{.nest_data} has
the following properties:
\itemize{
\item Rows are not affect.
\item Output columns are a subset of input columns, potentially with a different
order. Columns will be renamed if \code{new_name = old_name} form is used.
\item Data frame attributes are preserved.
\item Groups are maintained; you can't select off grouping variables.
}
}
\description{
\code{nest_select()} selects (and optionally renames) variables in nested data
frames, using a concise mini-language that makes it easy to refer to
variables based on their name (e.g., \code{a:f} selects all columns from \code{a} on
the left to \code{f} on the right). You can also use predicate functions like
\link{is.numeric} to select variables based on their properties.
}
\details{
\code{nest_select()} is largely a wrapper for \code{\link[dplyr:select]{dplyr::select()}} and maintains the
functionality of \code{select()} within each nested data frame. For more
information on \code{select()}, please refer to the documentation in
\href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)

gm_nest \%>\% nest_select(country_data, country, year, pop)
gm_nest \%>\% nest_select(country_data, dplyr::where(is.numeric))
}
\seealso{
Other single table verbs: 
\code{\link{nest_arrange}()},
\code{\link{nest_filter}()},
\code{\link{nest_mutate}()},
\code{\link{nest_rename}()},
\code{\link{nest_slice}()},
\code{\link{nest_summarise}()}
}
\concept{single table verbs}
