% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RoTBWLocalPoly.R
\name{RoTBWLocalPoly}
\alias{RoTBWLocalPoly}
\title{The rule-of-thumb bandwidth selector for the (partial) local polynomial regression.}
\usage{
RoTBWLocalPoly(
  Y,
  X,
  kernT = "epanechnikov",
  kernS = "epanechnikov",
  C_h = 7,
  C_b = 3
)
}
\arguments{
\item{Y}{The input n-dimensional outcome variable vector.}

\item{X}{The input n*(d+1) matrix. The first column of X stores the
treatment/exposure variables, while the other d columns are confounding variables.}

\item{kernT, kernS}{The names of kernel functions for the treatment/exposure
variable and confounding variables. (Default: kernT = "epanechnikov",
kernS = "epanechnikov".)}

\item{C_h, C_b}{The scaling factors for the rule-of-thumb bandwidth parameters.}
}
\value{
A list that contains two elements.
\item{h}{The rule-of-thumb bandwidth parameter for the treatment/exposure variable.}
\item{b}{The rule-of-thumb bandwidth vector for the confounding variables.}
}
\description{
This function implements the rule-of-thumb bandwidth selector for the (partial)
local polynomial regression.
}
\references{
Zhang, Y., Chen, Y.-C., and Giessing, A. (2024)
\emph{Nonparametric Inference on Dose-Response Curves Without the Positivity Condition.}
\url{https://arxiv.org/abs/2405.09003}.

Yang, L. and Tschernig, R. (1999). \emph{Multivariate Bandwidth Selection for
Local Linear Regression. Journal of the Royal Statistical Society Series B: Statistical Methodology,
61(4), 793-815.}
}
\author{
Yikun Zhang, \email{yikunzhang@foxmail.com}
}
\keyword{bandwidth}
\keyword{for}
\keyword{local}
\keyword{polynomial}
\keyword{regression}
\keyword{rule-of-thumb}
\keyword{selector}
