% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{PagesPropertiesEndpoint}
\alias{PagesPropertiesEndpoint}
\title{R6 Class for Pages Properties Endpoint}
\value{
A list containing the parsed API response.
}
\description{
Handle all pages properties operations in the Notion API

\strong{Note:} Access this endpoint through the client instance, e.g., \code{notion$pages$properties}. Not to be instantiated directly.
}
\examples{
\dontshow{if (notion_token_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
notion <- notion_client()

# ----- retrieve a page property
\dontshow{notionapi::vcr_example_start("notion-pages-properties-retrieve")}
notion$pages$properties$retrieve(
  "23933ea0-c1e4-8104-897b-f5a09269e561",
  property_id = "q;L^"
)
\dontshow{notionapi::vcr_example_end()}

# ----- update a page property
\dontshow{notionapi::vcr_example_start("notion-pages-properties-update")}
notion$pages$properties$update(
  "23933ea0-c1e4-8104-897b-f5a09269e561",
  list(
    `In stock` = list(
      checkbox = TRUE
    )
  )
)
\dontshow{notionapi::vcr_example_end()}
\dontshow{\}) # examplesIf}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PagesPropertiesEndpoint-new}{\code{PagesPropertiesEndpoint$new()}}
\item \href{#method-PagesPropertiesEndpoint-retrieve}{\code{PagesPropertiesEndpoint$retrieve()}}
\item \href{#method-PagesPropertiesEndpoint-update}{\code{PagesPropertiesEndpoint$update()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PagesPropertiesEndpoint-new"></a>}}
\if{latex}{\out{\hypertarget{method-PagesPropertiesEndpoint-new}{}}}
\subsection{Method \code{new()}}{
Initialise pages properties endpoint.
Not to be called directly, e.g., use \code{notion$pages$properties} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PagesPropertiesEndpoint$new(client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{Notion Client instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PagesPropertiesEndpoint-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-PagesPropertiesEndpoint-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Retrieve a page property item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PagesPropertiesEndpoint$retrieve(
  page_id,
  property_id,
  page_size = 100,
  start_cursor = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{page_id}}{Character (required). The ID for a Notion page.}

\item{\code{property_id}}{Character (required). The ID of the property to retrieve.}

\item{\code{page_size}}{Integer. Number of items to return per page (1-100). Defaults to 100.}

\item{\code{start_cursor}}{Character. For pagination. If provided, returns results starting from this cursor.
If NULL, returns the first page of results.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/retrieve-a-page-property}{Endpoint documentation}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PagesPropertiesEndpoint-update"></a>}}
\if{latex}{\out{\hypertarget{method-PagesPropertiesEndpoint-update}{}}}
\subsection{Method \code{update()}}{
Update a page property
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PagesPropertiesEndpoint$update(
  page_id,
  properties = NULL,
  in_trash = NULL,
  icon = NULL,
  cover = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{page_id}}{Character (required). The ID for a Notion page.}

\item{\code{properties}}{Named list (JSON object). Page properties to update as key-value pairs.}

\item{\code{in_trash}}{Boolean. Set to TRUE to move the block to trash (delete).
Set to FALSE to restore the block Defaults to FALSE.}

\item{\code{icon}}{Named list (JSON object). An icon for the page.}

\item{\code{cover}}{Named list (JSON object). A cover image for the page.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/patch-page}{Endpoint documentation}
}

}
}
