% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ark.R
\name{Ark}
\alias{Ark}
\title{A pseudonym archive}
\description{
An Ark object can create and remember pseudonyms.
Given the same input, it will always return the same pseudonym.
No pseudonym will repeat.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{log}}{Hashtable for all used pseudonyms. Inputs (keys) are stored
as hashes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Ark$new()}}
\item \href{#method-pseudonymize}{\code{Ark$pseudonymize()}}
\item \href{#method-print}{\code{Ark$print()}}
\item \href{#method-length}{\code{Ark$length()}}
\item \href{#method-length_allit}{\code{Ark$length_allit()}}
\item \href{#method-clone}{\code{Ark$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create new ark object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ark$new(alliterate = FALSE, parts = NULL, seed = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alliterate}}{Logical. Should the Ark return alliterations by
default?}

\item{\code{parts}}{List of character vectors with name parts to be used for the
pseudonyms. Defaults to adjectives and animals.}

\item{\code{seed}}{Random seed for permutation of name parts. Use this to make
Ark reproducible (to the extent that the random number generation is
reproducible). If NULL (default), the random number generator is left
alone. This is a convenience argument and equivalent to calling
\code{set.seed()} before creating the Ark.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Ark} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pseudonymize"></a>}}
\if{latex}{\out{\hypertarget{method-pseudonymize}{}}}
\subsection{Method \code{pseudonymize()}}{
Create Pseudonyms for input.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ark$pseudonymize(..., .alliterate = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{One or more R objects.}

\item{\code{.alliterate}}{Logical. Return only pseudonyms that are
alliterations. Defaults to TRUE if the Ark was created with
\code{Ark$new(alliterate = TRUE)}, FALSE otherwise. If FALSE, pseudonyms
may still be alliterations by coincidence.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character vector of pseudonyms with same length as input.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Pretty-print an Ark object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ark$print(n = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{A positive integer. The number of example pseudonyms to print.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-length"></a>}}
\if{latex}{\out{\hypertarget{method-length}{}}}
\subsection{Method \code{length()}}{
Number of used pseudonyms in an Ark.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ark$length()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-length_allit"></a>}}
\if{latex}{\out{\hypertarget{method-length_allit}{}}}
\subsection{Method \code{length_allit()}}{
Number of used alliterations in an Ark.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ark$length_allit()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ark$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
