% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rassocU}
\alias{rassocU}
\title{Generation of Points Associated in the Type U Sense with a Given Set of Points}
\usage{
rassocU(X1, n2, r0)
}
\arguments{
\item{X1}{A set of 2D points representing the reference points, also referred as class 1 points.
The generated points are associated in a type U sense (in a circular/radial fashion) with these points.}

\item{n2}{A positive integer representing the number of class 2 points to be generated.}

\item{r0}{A positive real number representing the radius of association of class 2 points associated with a
randomly selected class 1 point (see the description below).}
}
\value{
A \code{list} with the elements
\item{pat.type}{=\code{"ref.gen"} for the bivariate pattern of association of class 2 points with the reference points
(i.e., \eqn{X_1}), indicates reference points are required to be entered as an argument in the function}
\item{type}{The type of the point pattern}
\item{parameters}{Radius of association controlling the level of association}
\item{gen.points}{The output set of generated points (i.e., class 2 points) associated with reference (i.e.
\eqn{X_1} points)}
\item{ref.points}{The input set of reference points \eqn{X_1}, i.e., points with which generated class 2 points
are associated.}
\item{desc.pat}{Description of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of generated class 2 points and
the number of reference (i.e., \eqn{X_1}) points.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated and the reference points}
}
\description{
An object of class \code{"SpatPatterns"}.

Generates \code{n_2} 2D points associated with the given set of points (i.e., reference points) \eqn{X_1} in the
type U fashion with a radius of association \eqn{r_0} (denoted as \code{r0} as an argument of the function) which is a positive real number.
The generated points are intended to be from a different class, say class 2 (or \eqn{X_2} points) than the reference
(i.e., \eqn{X_1} points, say class 1 points, denoted as \code{X1} as an argument of the function), say class 1 points). 
To generate \eqn{n_2} (denoted as \code{n2} as an argument of the function)\eqn{X_2} points, \eqn{n_2} of \eqn{X_1} points are randomly selected (possibly with replacement) and
for a selected \code{X1} point, say \eqn{x_{1ref}},
a new point from the class 2, say \eqn{x_{2new}}, is generated uniformly within a
circle with radius equal to \eqn{r_0}.
That is, \eqn{x_{2new} = x_{1ref}+r_u c(\cos(t_u),\sin(t_u))}
where\eqn{r_u=sqrt(U)*r_0} with \eqn{U \sim U(0,1)} and \eqn{t_u \sim U(0, 2\pi)}.
Note that, the level of association increases as \eqn{r_0} decreases, and the association vanishes when \eqn{r_0} is 
sufficiently large.

For type U association, it is recommended to take \eqn{r_0 \le 0.10} times length of the shorter
edge of a rectangular study region, or take \eqn{r_0 = 1/(k \sqrt{\hat \rho})} with the appropriate choice of \eqn{k} 
to get an association pattern more robust to differences in relative abundances
(i.e., the choice of \eqn{k} implies \eqn{r_0 \le 0.10} times length of the shorter edge to have alternative patterns more 
robust to differences in sample sizes).
Here \eqn{\hat \rho} is the 
estimated intensity of points in the study region (i.e., # of points divided by the area of the region). 

Type U association is closely related to Type C association, see the function \code{\link{rassocC}}
and the other association types.
In the type C association pattern
the new point from the class 2, \eqn{x_{2new}}, is generated (uniform in the polar coordinates) within a circle
centered at \eqn{x_{1ref}} with radius equal to \eqn{r_0}.
In type G association, \eqn{x_{2new}} is generated from the bivariate normal distribution centered at \eqn{x_{1ref}} with covariance
\eqn{\sigma I_2} where \eqn{I_2} is \eqn{2 \times 2} identity matrix.
In type I association, first a \eqn{Uniform(0,1)} number, \eqn{U}, is generated.
If \eqn{U \le p}, \eqn{x_{2new}} is generated (uniform in the polar coordinates) within a
circle with radius equal to the distance to the closest \eqn{X_1} point,
else it is generated uniformly within the smallest bounding box containing \eqn{X_1} points.  

See \insertCite{ceyhan:serra-2014;textual}{nnspat} for more detail.
}
\examples{
n1<-20; n2<-1000;  #try also n1<-10; n2<-1000;

r0<-.15 #try also .10 and .20
#with default bounding box (i.e., unit square)
X1<-cbind(runif(n1),runif(n1))  #try also X1<-1+cbind(runif(n1),runif(n1))

Xdat<-rassocU(X1,n2,r0)
Xdat
summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#radius adjusted with the expected NN distance
x<-range(X1[,1]); y<-range(X1[,2])
ar<-(y[2]-y[1])*(x[2]-x[1]) #area of the smallest rectangular window containing X1 points
rho<-n1/ar
r0<-1/(2*sqrt(rho)) #r0=1/(2rho) where \code{rho} is the intensity of X1 points
Xdat<-rassocU(X1,n2,r0)
Xdat
summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rassocI}}, \code{\link{rassocG}}, \code{\link{rassocC}}, and \code{\link{rassoc}}
}
\author{
Elvan Ceyhan
}
