% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsZseg.coeff}
\alias{funsZseg.coeff}
\alias{Zseg.coeff.ct}
\alias{Zseg.coeff}
\title{Z Tests for Segregation Coefficients}
\usage{
Zseg.coeff.ct(
  ct,
  VarSC,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Zseg.coeff(
  dat,
  lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{Zseg.coeff.ct} only}

\item{VarSC}{The variance matrix for the segregation coefficients in the NNCT, \code{ct}; used in \code{Zseg.coeff.ct} only}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, for the segregation 
coefficients}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Zseg.coeff} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Zseg.coeff} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Zseg.coeff} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \code{matrix} of test statistics for the segregation coefficients}
\item{stat.names}{Name of the test statistics}
\item{p.value}{The \code{matrix} of \eqn{p}-values for the hypothesis test for the corresponding alternative}
\item{LCL,UCL}{Matrix of lower and upper confidence levels for the segregation coefficients at the given
confidence level \code{conf.level} and depends on the type of \code{alternative}.}
\item{conf.int}{Confidence interval for segregation coefficients, it is \code{NULL} here since we provide the upper 
and lower confidence limits as \eqn{k \times k} matrices.} 
\item{cnf.lvl}{Level of the upper and lower confidence limits of the segregation coefficients,
provided in \code{conf.level}.}
\item{estimate}{Estimate of the parameter, i.e., matrix of the observed segregation coefficients}
\item{est.name,est.name2}{Names of the estimates, both are same in this function}
\item{null.value}{Hypothesized null values for the parameters, i.e., expected values of the segregation 
coefficients, which are all 0 under RL or CSR.}
\item{null.name}{Name of the null value}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{Zseg.coeff.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Zseg.coeff} only}
}
\description{
Two functions: \code{Zseg.coeff.ct} and \code{Zseg.coeff}.

Both functions are objects of class \code{"cellhtest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of deviations of 
segregation coefficients from their expected values under RL or CSR for each segregation coefficient
in the NNCT.

The test for each cell \eqn{i,j} is based on the normal approximation of the corresponding segregation coefficient.
That is, each performs the segregation coefficient tests which are appropriate 
(i.e., have the appropriate asymptotic sampling distribution)
for completely mapped data.
The segregation coefficients in the multi-class case are the extension of Pielou's segregation coefficient
for the two-class case.
(See \insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat} for more detail).

Each function yields a contingency table of the test statistics, \eqn{p}-values for the corresponding 
alternative, lower and upper confidence levels, sample estimates (i.e., observed values) and null value
(i.e., expected value, which is 0) for the segregation coefficients
and also names of the test statistics, estimates, null value, the description of the test, and the data set used.

The null hypothesis for each cell \eqn{i,j} is that the corresponding segregation coefficient equal to the expected value
(which is 0) under RL or CSR.

See also (\insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

varT<-var.seg.coeff(ct,covN)

Zseg.coeff(Y,cls)
Zseg.coeff.ct(ct,varT)

Zseg.coeff(Y,cls,method="max")

Zseg.coeff(Y,cls,alt="g")
Zseg.coeff.ct(ct,varT,alt="g")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

Zseg.coeff.ct(ct,varT)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

varT<-var.seg.coeff(ct,covN)

Zseg.coeff(Y,cls)
Zseg.coeff.ct(ct,varT)

Zseg.coeff(Y,cls,alt="g")
Zseg.coeff.ct(ct,varT,alt="g")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{seg.coeff}} and \code{\link{Zseg.ind}}
}
\author{
Elvan Ceyhan
}
