% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{dist.std.data}
\alias{dist.std.data}
\title{Interpoint Distance Matrix for Standardized Data}
\usage{
dist.std.data(x, column = TRUE, ...)
}
\arguments{
\item{x}{A set of points in matrix or data frame form where points correspond to the rows.}

\item{column}{A logical argument (default is \code{TRUE}) to determine whether standardization is row-wise or
column-wise. If \code{TRUE} it is column-wise else row-wise standardization.}

\item{\dots}{Additional parameters to be passed on the \code{dist} function.}
}
\value{
A distance matrix whose  \eqn{i,j}-th entry is the distance between rows \eqn{i} and \eqn{j} of \code{x}, which is
standardized row-wise or column-wise.
}
\description{
This function computes and returns the distance matrix computed by using the specified distance measure 
to compute the distances between the rows of a data matrix which is standardized row or column-wise.
That is, the output is the interpoint distance (IPD) matrix of the rows of the given set of points \code{x}
\code{\link[stats]{dist}} function in the \code{stats} package of the standard R distribution.
The argument column is the logical argument (default=\code{TRUE}) to determine row-wise or column-wise standardization.
If \code{TRUE} each column is divided by its standard deviation, else each row is divided by its standard deviation.
This function is different from the \code{\link[stats]{dist}} function in the \code{stats} package.
\code{dist} returns the distance matrix in a lower triangular form, and dist.std.data returns in a full matrix
of distances of standardized data set.
\dots are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
range(ipd)

ipd2<-dist.std.data(Y) #distance of standardized data
range(ipd2)

ipd2<-dist.std.data(Y,method="max") #distance of standardized data
range(ipd2)

#############
Y<-matrix(runif(60,0,100),ncol=3)
ipd<-ipd.mat(Y)
range(ipd)

ipd2<-dist.std.data(Y) #distance of standardized data
range(ipd2)

}
\seealso{
\code{\link[stats]{dist}}, \code{\link{ipd.mat}}, and \code{\link{ipd.mat.euc}}
}
\author{
Elvan Ceyhan
}
