% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bins_Hertkorn2013}
\alias{bins_Hertkorn2013}
\title{NMR grouping bins from Hertkorn et al. (2013).}
\format{
A data frame with 5 rows and 5 variables:
\describe{
  \item{number}{Bin number}
  \item{group}{Name of bin group}
  \item{start}{ppm shift range, lower limit}
  \item{stop}{ppm shift range, upper limit}
  \item{description}{Description of the bin group}
}
}
\source{
N. Hertkorn et al. 2013. "High-field NMR spectroscopy and FTICR mass
spectrometry: powerful discovery tools for the molecular level
characterization of marine dissolved organic matter" Biogeosciences
\doi{10.5194/bg-10-1583-2013}
}
\usage{
bins_Hertkorn2013
}
\description{
NMR grouping bins from  Hertkorn et al. (2013), using MeOD as solvent.
(1) aliphatics, HCCC (0.0-1.9);
(2) acetate analogs and CRAM (carboxyl-rich alicyclic materials), HCX (1.9-3.1);
(3) carbohydrate-like and methoxy, HCO (3.1-4.9);
(4) olefinic HC=C (5.3-7.0);
(5) aromatic (7.0-10.0).
}
\note{
The NMR spectrum can be split into several bins, based on
chemical shift (ppm). Binsets are specific to nuclei and solvents and
by definition are open on the left and closed on the right;
for example, a bin of (0,1) includes 1 but \emph{not} 0.
}
\seealso{
\code{\link{bins_Clemente2012}} \code{\link{bins_Lynch2019}}
\code{\link{bins_Mitchell2018}}
}
\keyword{datasets}
