% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau_estimate.R
\name{tau_estimate}
\alias{tau_estimate}
\title{Non-linear shrinkage estimator of population eigenvalues.}
\usage{
tau_estimate(X, k = 0, method = "nlminb", control = list())
}
\arguments{
\item{X}{A data matrix.}

\item{k}{(Optional) Non-negative integer less than \code{ncol(X)}. If \code{k
== 0} (default), \code{X} is assumed to contain 1 class, which will be
centered. If \code{k >= 1}, \code{X} is assumed to contain \code{k}
classes, each of which has already been centered.}

\item{method}{(Optional) The optimization routine used. Choices are
\code{nlminb} (default) and \code{nloptr}.}

\item{control}{(Optional) A list of control parameters. Must correspond to
the selected optimization method. See \code{\link[stats]{nlminb}},
\code{\link[nloptr]{nloptr}} for details.}
}
\value{
A numeric vector of length \code{ncol(X)}, containing the population
  eigenvalue estimates, sorted in ascending order.
}
\description{
The population eigenvalue estimates are computed by numerically
  inverting the QuEST function (see references). The starting point is the
  linear shrinkage estimate of the population eigenvalues, computed using
  \code{\link{linshrink}}.
}
\section{NOTE}{
 \code{nlminb} is usually robust and accurate, but does not
  allow equality constraints, so, in general, the sum of the estimated
  population eigenvalues is not equal to the sum of the sample eigenvalues.
  \code{nloptr} enforces an equality constraint to preserve the trace, but is
  substantially slower than \code{nlminb}. The default optimizer used for
  \code{nloptr} is the Augmented Lagrangian method with local optimization
  using LBFGS. These can be modified using the control parameter.
}
\examples{
tau_estimate(X = matrix(rnorm(1e3, mean = 5), nrow = 50, ncol = 20))

}
\references{
\itemize{ \item Ledoit, O. and Wolf, M. (2015). Spectrum
  estimation: a unified framework for covariance matrix estimation and PCA in
  large dimensions. Journal of Multivariate Analysis, 139(2) \item Ledoit, O.
  and Wolf, M. (2016). Numerical Implementation of the QuEST function.
  arXiv:1601.05870 [stat.CO] }
}

