% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_modelfit.R
\name{run_npd_1cmpt_oral}
\alias{run_npd_1cmpt_oral}
\title{Run and evaluate a one-compartment oral model}
\usage{
run_npd_1cmpt_oral(
  dat,
  est.method = "nls",
  input.ka = exp(1),
  input.cl = exp(1),
  input.vd = exp(1),
  input.add = 1
)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in standard
nlmixr2 format.}

\item{est.method}{Estimation method used in nlmixr2. Defaults to "nls".}

\item{input.ka}{Initial estimate for the absorption rate constant (Ka).
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.cl}{Initial estimate for clearance (CL). Defaults to exp(1),
corresponding to a log-scale value of 1.}

\item{input.vd}{Initial estimate for volume of distribution (Vd). Defaults to
exp(1), corresponding to a log-scale value of 1.}

\item{input.add}{Additive error term. Defaults to 1.}
}
\value{
A list containing the fitted parameter estimates and prediction error
metrics.
}
\description{
Fits a one-compartment oral pharmacokinetic model using a naive pooled data
approach and evaluates model performance based on prediction error metrics.
}
\details{
Rows with \code{EVID == 2} are excluded before model fitting. The model is fitted
using \code{Fit_1cmpt_oral}, and prediction-based metrics are calculated to assess
performance.
}
\examples{
\donttest{
run_npd_1cmpt_oral(dat = Oral_1CPT, input.ka = 1, input.cl = 4, input.vd = 70)
 }
}
\seealso{
\code{\link{Fit_1cmpt_oral}}
}
\author{
Zhonghui Huang
}
