% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_modelfit.R
\name{run_npd_1cmpt_mm_oral}
\alias{run_npd_1cmpt_mm_oral}
\title{Run and evaluate a one-compartment oral model with Michaelis-Menten kinetics}
\usage{
run_npd_1cmpt_mm_oral(
  dat,
  est.method = "nls",
  input.ka = exp(1),
  input.vmax = exp(1),
  input.km = exp(1),
  input.cl = exp(1),
  input.vd = exp(1),
  input.add = 1,
  km_threshold = FALSE
)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in standard
nlmixr2 format.}

\item{est.method}{Estimation method used in nlmixr2. Defaults to "nls".}

\item{input.ka}{Initial estimate for the absorption rate constant (ka).
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.vmax}{Initial estimate for the maximum metabolic rate (Vmax).
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.km}{Initial estimate for the Michaelis constant (Km). Defaults to
exp(1), corresponding to a log-scale value of 1.}

\item{input.cl}{Initial estimate for clearance (CL). Defaults to exp(1),
corresponding to a log-scale value of 1. This value
is used to derive initial Vmax and Km when \code{km_threshold = TRUE}.}

\item{input.vd}{Initial estimate for volume of distribution (Vd). Defaults to
exp(1), corresponding to a log-scale value of 1.}

\item{input.add}{Additive error term. Defaults to 1.}

\item{km_threshold}{Logical indicating whether initial Vmax and Km should be
automatically adjusted based on observed maximum concentration and
clearance. Defaults to FALSE.}
}
\value{
A list containing the fitted parameter estimates and prediction error
metrics.
}
\description{
Fits a one-compartment oral pharmacokinetic model with Michaelis-Menten
elimination using a naive pooled data approach, and evaluates model
performance using prediction error metrics.
}
\details{
The function excludes dosing records (\code{EVID == 2}) prior to model fitting.
When \code{km_threshold = TRUE}, initial estimates for Vmax and Km are derived
using the observed maximum concentration and clearance. The model is then
fitted using \code{Fit_1cmpt_mm_oral}, and prediction-based metrics are calculated
to assess performance.
}
\examples{
\donttest{
  run_npd_1cmpt_mm_oral(
    dat = Oral_1CPTMM,
    input.ka = 1,
    input.vmax = 1000,
    input.km = 250,
    input.vd = 70
  )
}

}
\seealso{
\code{\link{Fit_1cmpt_mm_oral}}
}
\author{
Zhonghui Huang
}
