% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_ka.R
\name{run_ka_solution}
\alias{run_ka_solution}
\title{Estimate the absorption rate constant using pointwise methods}
\usage{
run_ka_solution(df, cl, ke, Fbio = 1)
}
\arguments{
\item{df}{A data frame containing raw time–concentration data in the
standard nlmixr2 format.}

\item{cl}{A numeric value for drug clearance. It is assumed constant across subjects unless pre-specified per subject.}

\item{ke}{A numeric value for the elimination rate constant. This is assumed known or estimated from the terminal phase.}

\item{Fbio}{A numeric value for bioavailability (F). Default is 1.}
}
\value{
A list with the following elements:
\describe{
\item{ka_calc_median}{Median ka value across all valid observations.}
\item{ka_calc_dat_sd}{Data frame containing absorption-phase single-dose data, with estimated ka and diagnostic messages.}
\item{ka_calc_dat_md}{Data frame containing absorption-phase steady-state multiple-dose data, with ka estimates.}
\item{ka_calc_dat}{Combined data frame (single-dose and multiple-dose) containing all ka estimates.}
}
}
\description{
It implements pointwise estimation of absorption rate constants for single-dose
and multiple-dose pharmacokinetic models.
}
\details{
For each subject, the time of maximum observed concentration (Tmax) is identified as the time corresponding to the highest DV.
Only records with TIME less than or equal to Tmax are retained, representing the absorption phase.

Two scenario-specific calculations are implemented: single-dose and multiple-dose at steady state.
\itemize{
\item For single-dose data (dose_number == 1 and SteadyState == FALSE), the function uses \code{ka_calculation_sd()},
which applies a one-compartment oral absorption model under first-order absorption and elimination.
\item For steady-state multiple-dose data (dose_number > 1 and SteadyState == TRUE), the function uses \code{ka_calculation_md()},
which accounts for accumulation using the dosing interval (dose_interval).
}

This function does not perform model fitting. The median is recommended for use in pharmacokinetic modeling.
}
\examples{
# Single-dose
df <- Oral_1CPT[Oral_1CPT$SD == 1, ]
df <- processData(df)$dat
df <- is_ss(df)
run_ka_solution(df = df, cl = 4, ke = 4/70, Fbio = 1)$ka_calc_median

# Mixed doses
dat <- Oral_1CPT
df_ss <- processData(dat)$dat
df_ss <- is_ss(df_ss)
run_ka_solution(df = df_ss, cl = 4, ke = 4/70, Fbio = 1)$ka_calc_median

}
\author{
Zhonghui Huang
}
