% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wombling_gaussian.R
\name{wombling_gaussian}
\alias{wombling_gaussian}
\title{Posterior samples for wombling measures for the squared exponential kernel}
\usage{
wombling_gaussian(coords, curve, dists, tvec, umat, z, phi, sigma2)
}
\arguments{
\item{coords}{coordinates}

\item{curve}{curve coordinates}

\item{dists}{distance matrix}

\item{tvec}{vector of t's}

\item{umat}{matrix of u's}

\item{z}{posterior samples of \eqn{Z(s)}}

\item{phi}{posterior samples of \eqn{\phi}}

\item{sigma2}{posterior samples of \eqn{\sigma^2}}
}
\value{
A matrix of wombling measures. For internal use only.
}
\description{
For internal use only.
}
\examples{
\dontrun{
#####################
# Internal use only #
#####################
# Example usage inside of nimblewomble::spwombling(...)
WG = compileNimble(wombling_gaussian)
wmeasure = WG(coords = coords,
              curve = curve,
              dists = distM,
              tvec = tvec,
              umat = umat,
              z = z,
              phi = phi,
              sigma2 = sigma2)
}
}
\author{
Aritra Halder <aritra.halder@drexel.edu>, \cr
Sudipto Banerjee <sudipto@ucla.edu>
}
\keyword{wombling_gaussian}
