% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NilsEstimate-filter.R
\name{efilter}
\alias{efilter}
\alias{efilter.NilsEstimate}
\title{Filter NILS estimates}
\usage{
efilter(obj, ...)

\method{efilter}{NilsEstimate}(obj, psus = NULL, categories = NULL, ...)
}
\arguments{
\item{obj}{A \link{NilsEstimate} object.}

\item{...}{Additional arguments (currently unused)}

\item{psus}{An optional vector of PSU IDs to keep.}

\item{categories}{An optional vector of the category IDs to keep.}
}
\value{
a filtered \link{NilsEstimate} object.
}
\description{
Filters a \link{NilsEstimate} object by PSU level or category.
}
\examples{
obj = NilsEstimate(plots, tracts, psus, category_psu_map);

# Keep only category with ID 1
efilter(obj, categories = 1)

# Keep PSU 5
efilter(obj, psus = 5)


}
