% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_nichevol.R
\name{map_nichevol}
\alias{map_nichevol}
\title{Maps of niche reconstructions and changes detected}
\usage{
map_nichevol(whole_rec_table, variable, return = "niche", from, to = NULL,
             id_unknown = TRUE, verbose = TRUE)
}
\arguments{
\item{whole_rec_table}{matrix of environmental bins for all tips and nodes
derived from functions \code{\link{bin_par_rec}} or \code{\link{bin_ml_rec}}.}

\item{variable}{a SpatRaster layer corresponding to the variable for which
the reconstruction was performed (represented in \code{whole_rec_table}).}

\item{return}{(character) type of result to return. Options are: "niche",
"evolution", or "nichevol" (a combination of both). Default = "niche". If
"niche", values correspond to that defined in \code{from}. See Value.}

\item{from}{(character) if \code{return} = "niche" tip or node for which layer
will be prepared, otherwise, initial node from which niche comparison will be
performed. See example.}

\item{to}{(character) valid if \code{return} = "evolution" or "nichevol".
Tip or node to compare against \code{from} to detected changes.
Default = NULL. See example.}

\item{id_unknown}{(logical) whether to identify areas of unknown or uncertain
change. Default = TRUE. See details.}

\item{verbose}{(logical) whether messages should be printed. Default = TRUE.}
}
\value{
A SpatRaster object classified according to values of niche in
\code{whole_rec_table}, and/or according to niche changes detected in
comparisons between an ancestor and a tip, or another more recent ancestor.

Options of values resulting from classifications are as follow:

If \code{return} = "niche":\tabular{ll}{
   ID \tab category \cr
   0 \tab Absent \cr
   10 \tab Unknown \cr
   100 \tab Present \cr
}


If \code{return} = "evolution":\tabular{ll}{
   ID \tab category \cr
   0 \tab Stable \cr
   1 \tab Expansion low \cr
   3 \tab Expansion high \cr
   2 \tab Retraction high \cr
   4 \tab Retraction low \cr
   10 \tab Unknown \cr
}


If \code{return} = "nichevol":\tabular{ll}{
   ID \tab category \cr
   0 \tab Stable \cr
   1 \tab Expansion low \cr
   3 \tab Expansion high \cr
   10 \tab Unknown \cr
   100 \tab Present \cr
   102 \tab Retraction high \cr
   104 \tab Retraction low \cr
}
}
\description{
map_nichevol produces a SpatRaster layer representing
geographic areas corresponding to environmental bins of niche or events of
niche evolution detected in reconstructions.
}
\details{
Mapping is done following Cobos et al. (2021) \url{doi:10.1111/jav.02868}.
This allows to represent geographic areas with environments where
niche expanded, retracted, or stayed stable (evolution). Niche is
represented as presence, absence, or unknown.

Defining \code{id_unknown} = TRUE allows to map areas where niche or niche
change are uncertain. \code{id_unknown} = FALSE returns NA in areas with these
characteristics, hence they will not be visible when plotting the resulting
map.
}
\examples{
# a tree
data("tree", package = "nichevol")

# raster variable
temp <- terra::rast(system.file("extdata", "temp.tif", package = "nichevol"))

# results from reconstruction
data("par_rec_table", package = "nichevol")

# rename tree tips
tree$tip.label <- rownames(par_rec_table)[1:6]

# check in plot
plot.phylo(tree, label.offset = 0.02)
nodelabels()
nichevol_labels(tree, par_rec_table)

# mapping nichevol
nevol_map <- map_nichevol(whole_rec_table = par_rec_table, variable = temp,
                          return = "nichevol", from = "9", to = "RD 6933")

terra::plot(nevol_map)
}
