% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_param_est.R
\name{bootstrap_param_est}
\alias{bootstrap_param_est}
\title{Estimation of Markov model.}
\usage{
bootstrap_param_est(
  wide,
  b,
  days = paste0("D", 1:28),
  bin = rep(1, length(days) - 1),
  Em = get_emission(wide, days),
  tol = 1e-06,
  maxiter = 200,
  silent = FALSE
)
}
\arguments{
\item{wide}{Data in wide format (i.e., each day is a column). See details.}

\item{b}{Number of bootstrap samples to take.}

\item{days}{Names of the columns that contain the score for each day.}

\item{bin}{The assigned bin for pooling together information across transitions. Must be a numeric vector of length=(length(days)-1). By default all transitions are pooled together.}

\item{Em}{Emission probabilities. Default should be used unless user is advanced.}

\item{tol}{Tolerance for relative reduction the log-likelihood to determine convergence of the Baum-Welch algorythm.}

\item{maxiter}{Maximum iterations before stopping the EM algorithm.}

\item{silent}{Allows silencing some messages.}
}
\value{
A list object with the following components:
\describe{
  \item{fit}{Contains results of the primary model fit}
  \item{boot}{Contains relults from the bootstrap model fit.}
  \item{bin}{The input.}
  \item{s}{Ignor. May be used in future.}
  \item{days}{From input.}
  \item{Em}{From input.}
}
}
\description{
Fits a Markov model then bootstraps the data and refits the model.
}
\details{
States for each patient/day in 'wide' may be the following: 
\itemize{
 \item{Not missing:}{An integer from 1 to 8.}
 \item{Missing:}{NA}
 \item{Partially Missing:}{ range which may be code as a characters string such as '[1,7]' or '[1,2]'. Such a character string indicates that while the actual value is unknown, it is known that the value falls within the specified range. }
}
Generally the user will not need to call this function directly because it is called by the 'impute' function.
}
\examples{
test <- sim_data(100)
bs <- bootstrap_param_est(wide=test,b=2)
}
\seealso{
\code{\link{impute}}
}
