% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/button.R
\name{submitButton}
\alias{submitButton}
\title{Create a submit button}
\usage{
submitButton(
  inputId,
  text = "Apply Changes",
  icon = NULL,
  width = NULL,
  size = c("m", "xs", "s", "l", "xl"),
  style = c("default", "pill", "round", "clean"),
  bg.type = c("default", "primary", "secondary", "info", "success", "danger", "warning"),
  outline = FALSE
)
}
\arguments{
\item{inputId}{input id}

\item{text}{Button text}

\item{icon}{Choice of button icon}

\item{width}{Width of the bottom}

\item{size}{Size of the button, choices include "m","xs", "s", "l", "xl"}

\item{style}{Style of the button, choices include "default", "pill", "round", "clean"}

\item{bg.type}{Color of the button, choices include "default", "primary", "secondary", "info", "success", "danger", "warning"}

\item{outline}{Use an outline styling, TRUE or FALSE}
}
\value{
HTML of the submit buttons to insert into a page
}
\description{
Upgrade to the submitButton in 'Shiny' package
}
\examples{
if (interactive()) {
card(
  shiny::h2("Submit buttons with various styles"),
  header = FALSE,
  shiny::div(submitButton("Submit button with primary color",
    icon = shiny::icon("file"), size = "s", bg.type = "primary"
  )),
  shiny::div(submitButton("Secondary color",
    icon = shiny::icon("folder"), bg.type = "secondary"
  )),
  shiny::div(submitButton("Success color",
    icon = shiny::icon("filter"), bg.type = "success"
  )),
  shiny::div(submitButton("Warning color",
    icon = shiny::icon("grid"), bg.type = "warning"
  )),
  shiny::div(submitButton("Danger color",
    icon = shiny::icon("check"), bg.type = "danger"
  )),
  shiny::div(submitButton("Info color",
    icon = shiny::icon("trash"), bg.type = "info"
  ))
)
}
}
