% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMVC.R
\name{IMVCS}
\alias{IMVCS}
\title{Integrated Mean Variance Correlation Based Screening}
\usage{
IMVCS(y, x, K, d, NN = 3, type)
}
\arguments{
\item{y}{is the response vector}

\item{x}{is the covariate matrix}

\item{K}{is the number of quantile levels}

\item{d}{is the size of selected variables}

\item{NN}{is the number of B spline basis, default is 3}

\item{type}{is an indicator for measuring linear or nonlinear correlation, "linear" represents linear correlation and "nonlinear" represents linear or nonlinear correlation using B splines}
}
\value{
The labels of first d largest active set of all predictors
}
\description{
This function is used to select important features using integrated mean variance correlation
}
\examples{
require("mvtnorm")
n=200
p=500
pho1=0.8
mean_x=rep(0,p)
sigma_x=matrix(NA,nrow = p,ncol = p)
for (i in 1:p) {
 for (j in 1:p) {
   sigma_x[i,j]=pho1^(abs(i-j))
 }
}
x=rmvnorm(n, mean = mean_x, sigma = sigma_x,method = "chol")
x1=x[,1]
x2=x[,2]
x3=x[,12]
x4=x[,22]
y=2*x1+0.5*x2+3*x3*ifelse(x3<0,1,0)+2*x4+rnorm(n)

IMVCS(y,x,K=5,d=round(n/log(n)),type="nonlinear")
}
