// Generated by rstantools.  Do not edit by hand.

/*
    networkscaleup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    networkscaleup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with networkscaleup.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_Correlated_x_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 54> locations_array__ =
  {" (found before start of program)",
  " (in 'Correlated_x', line 8, column 2 to column 20)",
  " (in 'Correlated_x', line 9, column 2 to column 28)",
  " (in 'Correlated_x', line 10, column 2 to column 22)",
  " (in 'Correlated_x', line 11, column 2 to column 20)",
  " (in 'Correlated_x', line 12, column 2 to column 29)",
  " (in 'Correlated_x', line 13, column 2 to column 36)",
  " (in 'Correlated_x', line 14, column 2 to column 18)",
  " (in 'Correlated_x', line 15, column 2 to column 14)",
  " (in 'Correlated_x', line 16, column 2 to column 26)",
  " (in 'Correlated_x', line 19, column 2 to column 17)",
  " (in 'Correlated_x', line 20, column 2 to column 18)",
  " (in 'Correlated_x', line 21, column 2 to column 23)",
  " (in 'Correlated_x', line 22, column 2 to column 127)",
  " (in 'Correlated_x', line 44, column 2 to column 24)",
  " (in 'Correlated_x', line 24, column 2 to column 45)",
  " (in 'Correlated_x', line 25, column 2 to column 39)",
  " (in 'Correlated_x', line 26, column 2 to column 79)",
  " (in 'Correlated_x', line 45, column 2 to column 28)",
  " (in 'Correlated_x', line 29, column 2 to column 23)",
  " (in 'Correlated_x', line 30, column 2 to column 31)",
  " (in 'Correlated_x', line 31, column 2 to column 25)",
  " (in 'Correlated_x', line 32, column 2 to column 32)",
  " (in 'Correlated_x', line 33, column 2 to column 33)",
  " (in 'Correlated_x', line 34, column 2 to column 24)",
  " (in 'Correlated_x', line 35, column 2 to column 29)",
  " (in 'Correlated_x', line 36, column 2 to column 25)",
  " (in 'Correlated_x', line 37, column 2 to column 34)",
  " (in 'Correlated_x', line 40, column 4 to column 47)",
  " (in 'Correlated_x', line 39, column 17 to line 41, column 3)",
  " (in 'Correlated_x', line 39, column 2 to line 41, column 3)",
  " (in 'Correlated_x', line 2, column 2 to column 19)",
  " (in 'Correlated_x', line 3, column 2 to column 19)",
  " (in 'Correlated_x', line 4, column 9 to column 12)",
  " (in 'Correlated_x', line 4, column 14 to column 17)",
  " (in 'Correlated_x', line 4, column 2 to column 21)",
  " (in 'Correlated_x', line 5, column 8 to column 11)",
  " (in 'Correlated_x', line 5, column 12 to column 15)",
  " (in 'Correlated_x', line 5, column 2 to column 17)",
  " (in 'Correlated_x', line 8, column 9 to column 12)",
  " (in 'Correlated_x', line 10, column 9 to column 12)",
  " (in 'Correlated_x', line 10, column 13 to column 16)",
  " (in 'Correlated_x', line 11, column 9 to column 12)",
  " (in 'Correlated_x', line 12, column 18 to column 21)",
  " (in 'Correlated_x', line 13, column 23 to column 26)",
  " (in 'Correlated_x', line 14, column 9 to column 12)",
  " (in 'Correlated_x', line 19, column 9 to column 12)",
  " (in 'Correlated_x', line 20, column 9 to column 12)",
  " (in 'Correlated_x', line 21, column 9 to column 12)",
  " (in 'Correlated_x', line 21, column 13 to column 16)",
  " (in 'Correlated_x', line 22, column 9 to column 12)",
  " (in 'Correlated_x', line 22, column 13 to column 16)",
  " (in 'Correlated_x', line 44, column 9 to column 12)",
  " (in 'Correlated_x', line 44, column 14 to column 17)"};
#include <stan_meta_header.hpp>
class model_Correlated_x final : public model_base_crtp<model_Correlated_x> {
private:
  int n_i;
  int n_k;
  Eigen::Matrix<double,-1,-1> x_data__;
  std::vector<std::vector<int>> y;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> x{nullptr, 0, 0};
public:
  ~model_Correlated_x() {}
  model_Correlated_x(stan::io::var_context& context__, unsigned int
                     random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_Correlated_x_namespace::model_Correlated_x";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 31;
      context__.validate_dims("data initialization", "n_i", "int",
        std::vector<size_t>{});
      n_i = std::numeric_limits<int>::min();
      current_statement__ = 31;
      n_i = context__.vals_i("n_i")[(1 - 1)];
      current_statement__ = 31;
      stan::math::check_greater_or_equal(function__, "n_i", n_i, 0);
      current_statement__ = 32;
      context__.validate_dims("data initialization", "n_k", "int",
        std::vector<size_t>{});
      n_k = std::numeric_limits<int>::min();
      current_statement__ = 32;
      n_k = context__.vals_i("n_k")[(1 - 1)];
      current_statement__ = 32;
      stan::math::check_greater_or_equal(function__, "n_k", n_k, 0);
      current_statement__ = 33;
      stan::math::validate_non_negative_index("x", "n_i", n_i);
      current_statement__ = 34;
      stan::math::validate_non_negative_index("x", "n_k", n_k);
      current_statement__ = 35;
      context__.validate_dims("data initialization", "x", "double",
        std::vector<size_t>{static_cast<size_t>(n_i),
          static_cast<size_t>(n_k)});
      x_data__ = Eigen::Matrix<double,-1,-1>::Constant(n_i, n_k,
                   std::numeric_limits<double>::quiet_NaN());
      new (&x) Eigen::Map<Eigen::Matrix<double,-1,-1>>(x_data__.data(), n_i,
        n_k);
      {
        std::vector<local_scalar_t__> x_flat__;
        current_statement__ = 35;
        x_flat__ = context__.vals_r("x");
        current_statement__ = 35;
        pos__ = 1;
        current_statement__ = 35;
        for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
          current_statement__ = 35;
          for (int sym2__ = 1; sym2__ <= n_i; ++sym2__) {
            current_statement__ = 35;
            stan::model::assign(x, x_flat__[(pos__ - 1)],
              "assigning variable x", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 35;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 36;
      stan::math::validate_non_negative_index("y", "n_i", n_i);
      current_statement__ = 37;
      stan::math::validate_non_negative_index("y", "n_k", n_k);
      current_statement__ = 38;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>(n_i),
          static_cast<size_t>(n_k)});
      y = std::vector<std::vector<int>>(n_i,
            std::vector<int>(n_k, std::numeric_limits<int>::min()));
      {
        std::vector<int> y_flat__;
        current_statement__ = 38;
        y_flat__ = context__.vals_i("y");
        current_statement__ = 38;
        pos__ = 1;
        current_statement__ = 38;
        for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
          current_statement__ = 38;
          for (int sym2__ = 1; sym2__ <= n_i; ++sym2__) {
            current_statement__ = 38;
            stan::model::assign(y, y_flat__[(pos__ - 1)],
              "assigning variable y", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 38;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 39;
      stan::math::validate_non_negative_index("delta", "n_i", n_i);
      current_statement__ = 40;
      stan::math::validate_non_negative_index("eps", "n_i", n_i);
      current_statement__ = 41;
      stan::math::validate_non_negative_index("eps", "n_k", n_k);
      current_statement__ = 42;
      stan::math::validate_non_negative_index("alpha", "n_k", n_k);
      current_statement__ = 43;
      stan::math::validate_non_negative_index("tau_N", "n_k", n_k);
      current_statement__ = 44;
      stan::math::validate_non_negative_index("L_Omega", "n_k", n_k);
      current_statement__ = 44;
      stan::math::validate_non_negative_index("L_Omega", "n_k", n_k);
      current_statement__ = 45;
      stan::math::validate_non_negative_index("rho", "n_k", n_k);
      current_statement__ = 46;
      stan::math::validate_non_negative_index("mu", "n_k", n_k);
      current_statement__ = 47;
      stan::math::validate_non_negative_index("tau", "n_k", n_k);
      current_statement__ = 48;
      stan::math::validate_non_negative_index("bias", "n_i", n_i);
      current_statement__ = 49;
      stan::math::validate_non_negative_index("bias", "n_k", n_k);
      current_statement__ = 50;
      stan::math::validate_non_negative_index("prev_mean", "n_i", n_i);
      current_statement__ = 51;
      stan::math::validate_non_negative_index("prev_mean", "n_k", n_k);
      current_statement__ = 52;
      stan::math::validate_non_negative_index("Corr", "n_k", n_k);
      current_statement__ = 53;
      stan::math::validate_non_negative_index("Corr", "n_k", n_k);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = n_i + 1 + (n_i * n_k) + n_k + n_k + ((n_k * (n_k - 1)) /
      2) + n_k + 1 + 1;
  }
  inline std::string model_name() const final {
    return "model_Correlated_x";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_Correlated_x_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> delta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_i, DUMMY_VAR__);
      current_statement__ = 1;
      delta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_i);
      local_scalar_t__ sigma_delta = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_delta = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,-1> eps =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_i, n_k,
          DUMMY_VAR__);
      current_statement__ = 3;
      eps = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(n_i,
              n_k);
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_k, DUMMY_VAR__);
      current_statement__ = 4;
      alpha = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_k);
      Eigen::Matrix<local_scalar_t__,-1,1> tau_N =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_k, DUMMY_VAR__);
      current_statement__ = 5;
      tau_N = in__.template read_constrain_lb<
                Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
                n_k);
      Eigen::Matrix<local_scalar_t__,-1,-1> L_Omega =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_k, n_k,
          DUMMY_VAR__);
      current_statement__ = 6;
      L_Omega = in__.template read_constrain_cholesky_factor_corr<
                  Eigen::Matrix<local_scalar_t__,-1,-1>, jacobian__>(lp__,
                  n_k);
      Eigen::Matrix<local_scalar_t__,-1,1> rho =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_k, DUMMY_VAR__);
      current_statement__ = 7;
      rho = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_k);
      local_scalar_t__ mu_rho = DUMMY_VAR__;
      current_statement__ = 8;
      mu_rho = in__.template read<local_scalar_t__>();
      local_scalar_t__ sigma_rho = DUMMY_VAR__;
      current_statement__ = 9;
      sigma_rho = in__.template read_constrain_lb<local_scalar_t__,
                    jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> mu =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_k, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> tau =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_k, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,-1> bias =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_i, n_k,
          DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,-1> prev_mean =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_i, n_k,
          DUMMY_VAR__);
      current_statement__ = 13;
      stan::model::assign(prev_mean,
        stan::math::exp(
          stan::math::add(
            stan::math::add(
              stan::math::transpose(stan::math::rep_matrix(rho, n_i)),
              stan::math::elt_multiply(x,
                stan::math::transpose(stan::math::rep_matrix(alpha, n_i)))),
            stan::math::rep_matrix(stan::math::multiply(sigma_delta, delta),
              n_k))), "assigning variable prev_mean");
      current_statement__ = 15;
      stan::model::assign(mu,
        stan::math::log(
          stan::math::elt_divide(1.0,
            stan::math::sqrt(stan::math::add(1.0, stan::math::square(tau_N))))),
        "assigning variable mu");
      current_statement__ = 16;
      stan::model::assign(tau,
        stan::math::sqrt(
          stan::math::log(stan::math::add(1.0, stan::math::square(tau_N)))),
        "assigning variable tau");
      current_statement__ = 17;
      stan::model::assign(bias,
        stan::math::exp(
          stan::math::add(
            stan::math::transpose(stan::math::rep_matrix(mu, n_i)),
            stan::math::transpose(
              stan::math::multiply(
                stan::math::diag_pre_multiply(tau, L_Omega),
                stan::math::transpose(eps))))), "assigning variable bias");
      {
        current_statement__ = 19;
        lp_accum__.add(stan::math::std_normal_lpdf<propto__>(delta));
        current_statement__ = 20;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(sigma_delta, 0, 2.5));
        current_statement__ = 21;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(tau_N, 0, 2.5));
        current_statement__ = 22;
        lp_accum__.add(stan::math::std_normal_lpdf<propto__>(
                         stan::math::to_vector(eps)));
        current_statement__ = 23;
        lp_accum__.add(stan::math::lkj_corr_cholesky_lpdf<propto__>(L_Omega,
                         2));
        current_statement__ = 24;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(alpha, 0, 10));
        current_statement__ = 25;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(sigma_rho, 0, 2.5));
        current_statement__ = 26;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(mu_rho, 0, 10));
        current_statement__ = 27;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(rho, mu_rho,
                         sigma_rho));
        current_statement__ = 30;
        for (int k = 1; k <= n_k; ++k) {
          current_statement__ = 28;
          lp_accum__.add(stan::math::poisson_lpmf<propto__>(
                           stan::model::rvalue(y, "y",
                             stan::model::index_omni(),
                             stan::model::index_uni(k)),
                           stan::math::elt_multiply(
                             stan::model::rvalue(prev_mean, "prev_mean",
                               stan::model::index_omni(),
                               stan::model::index_uni(k)),
                             stan::model::rvalue(bias, "bias",
                               stan::model::index_omni(),
                               stan::model::index_uni(k)))));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_Correlated_x_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> delta =
        Eigen::Matrix<double,-1,1>::Constant(n_i,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      delta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_i);
      double sigma_delta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      sigma_delta = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,-1> eps =
        Eigen::Matrix<double,-1,-1>::Constant(n_i, n_k,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      eps = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(n_i,
              n_k);
      Eigen::Matrix<double,-1,1> alpha =
        Eigen::Matrix<double,-1,1>::Constant(n_k,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      alpha = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_k);
      Eigen::Matrix<double,-1,1> tau_N =
        Eigen::Matrix<double,-1,1>::Constant(n_k,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      tau_N = in__.template read_constrain_lb<
                Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
                n_k);
      Eigen::Matrix<double,-1,-1> L_Omega =
        Eigen::Matrix<double,-1,-1>::Constant(n_k, n_k,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 6;
      L_Omega = in__.template read_constrain_cholesky_factor_corr<
                  Eigen::Matrix<local_scalar_t__,-1,-1>, jacobian__>(lp__,
                  n_k);
      Eigen::Matrix<double,-1,1> rho =
        Eigen::Matrix<double,-1,1>::Constant(n_k,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 7;
      rho = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_k);
      double mu_rho = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 8;
      mu_rho = in__.template read<local_scalar_t__>();
      double sigma_rho = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 9;
      sigma_rho = in__.template read_constrain_lb<local_scalar_t__,
                    jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,1> mu =
        Eigen::Matrix<double,-1,1>::Constant(n_k,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> tau =
        Eigen::Matrix<double,-1,1>::Constant(n_k,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,-1> bias =
        Eigen::Matrix<double,-1,-1>::Constant(n_i, n_k,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,-1> prev_mean =
        Eigen::Matrix<double,-1,-1>::Constant(n_i, n_k,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(delta);
      out__.write(sigma_delta);
      out__.write(eps);
      out__.write(alpha);
      out__.write(tau_N);
      out__.write(L_Omega);
      out__.write(rho);
      out__.write(mu_rho);
      out__.write(sigma_rho);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 13;
      stan::model::assign(prev_mean,
        stan::math::exp(
          stan::math::add(
            stan::math::add(
              stan::math::transpose(stan::math::rep_matrix(rho, n_i)),
              stan::math::elt_multiply(x,
                stan::math::transpose(stan::math::rep_matrix(alpha, n_i)))),
            stan::math::rep_matrix(stan::math::multiply(sigma_delta, delta),
              n_k))), "assigning variable prev_mean");
      current_statement__ = 15;
      stan::model::assign(mu,
        stan::math::log(
          stan::math::elt_divide(1.0,
            stan::math::sqrt(stan::math::add(1.0, stan::math::square(tau_N))))),
        "assigning variable mu");
      current_statement__ = 16;
      stan::model::assign(tau,
        stan::math::sqrt(
          stan::math::log(stan::math::add(1.0, stan::math::square(tau_N)))),
        "assigning variable tau");
      current_statement__ = 17;
      stan::model::assign(bias,
        stan::math::exp(
          stan::math::add(
            stan::math::transpose(stan::math::rep_matrix(mu, n_i)),
            stan::math::transpose(
              stan::math::multiply(
                stan::math::diag_pre_multiply(tau, L_Omega),
                stan::math::transpose(eps))))), "assigning variable bias");
      if (emit_transformed_parameters__) {
        out__.write(mu);
        out__.write(tau);
        out__.write(bias);
        out__.write(prev_mean);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,-1> Corr =
        Eigen::Matrix<double,-1,-1>::Constant(n_k, n_k,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 18;
      stan::model::assign(Corr,
        stan::math::multiply(L_Omega, stan::math::transpose(L_Omega)),
        "assigning variable Corr");
      out__.write(Corr);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> delta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_i, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(delta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_i),
        "assigning variable delta");
      out__.write(delta);
      local_scalar_t__ sigma_delta = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_delta = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_delta);
      Eigen::Matrix<local_scalar_t__,-1,-1> eps =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_i, n_k,
          DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(eps,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(n_i, n_k),
        "assigning variable eps");
      out__.write(eps);
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_k, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(alpha,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_k),
        "assigning variable alpha");
      out__.write(alpha);
      Eigen::Matrix<local_scalar_t__,-1,1> tau_N =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_k, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(tau_N,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_k),
        "assigning variable tau_N");
      out__.write_free_lb(0, tau_N);
      Eigen::Matrix<local_scalar_t__,-1,-1> L_Omega =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_k, n_k,
          DUMMY_VAR__);
      current_statement__ = 6;
      stan::model::assign(L_Omega,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(n_k, n_k),
        "assigning variable L_Omega");
      out__.write_free_cholesky_factor_corr(L_Omega);
      Eigen::Matrix<local_scalar_t__,-1,1> rho =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_k, DUMMY_VAR__);
      current_statement__ = 7;
      stan::model::assign(rho,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_k),
        "assigning variable rho");
      out__.write(rho);
      local_scalar_t__ mu_rho = DUMMY_VAR__;
      current_statement__ = 8;
      mu_rho = in__.read<local_scalar_t__>();
      out__.write(mu_rho);
      local_scalar_t__ sigma_rho = DUMMY_VAR__;
      current_statement__ = 9;
      sigma_rho = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_rho);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "delta", "double",
        std::vector<size_t>{static_cast<size_t>(n_i)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "sigma_delta",
        "double", std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "eps", "double",
        std::vector<size_t>{static_cast<size_t>(n_i),
          static_cast<size_t>(n_k)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "alpha", "double",
        std::vector<size_t>{static_cast<size_t>(n_k)});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "tau_N", "double",
        std::vector<size_t>{static_cast<size_t>(n_k)});
      current_statement__ = 6;
      context__.validate_dims("parameter initialization", "L_Omega",
        "double",
        std::vector<size_t>{static_cast<size_t>(n_k),
          static_cast<size_t>(n_k)});
      current_statement__ = 7;
      context__.validate_dims("parameter initialization", "rho", "double",
        std::vector<size_t>{static_cast<size_t>(n_k)});
      current_statement__ = 8;
      context__.validate_dims("parameter initialization", "mu_rho", "double",
        std::vector<size_t>{});
      current_statement__ = 9;
      context__.validate_dims("parameter initialization", "sigma_rho",
        "double", std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> delta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_i, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> delta_flat__;
        current_statement__ = 1;
        delta_flat__ = context__.vals_r("delta");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= n_i; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(delta, delta_flat__[(pos__ - 1)],
            "assigning variable delta", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(delta);
      local_scalar_t__ sigma_delta = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_delta = context__.vals_r("sigma_delta")[(1 - 1)];
      out__.write_free_lb(0, sigma_delta);
      Eigen::Matrix<local_scalar_t__,-1,-1> eps =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_i, n_k,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> eps_flat__;
        current_statement__ = 3;
        eps_flat__ = context__.vals_r("eps");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= n_i; ++sym2__) {
            current_statement__ = 3;
            stan::model::assign(eps, eps_flat__[(pos__ - 1)],
              "assigning variable eps", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 3;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(eps);
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_k, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 4;
        alpha_flat__ = context__.vals_r("alpha");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
          current_statement__ = 4;
          stan::model::assign(alpha, alpha_flat__[(pos__ - 1)],
            "assigning variable alpha", stan::model::index_uni(sym1__));
          current_statement__ = 4;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(alpha);
      Eigen::Matrix<local_scalar_t__,-1,1> tau_N =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_k, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> tau_N_flat__;
        current_statement__ = 5;
        tau_N_flat__ = context__.vals_r("tau_N");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
          current_statement__ = 5;
          stan::model::assign(tau_N, tau_N_flat__[(pos__ - 1)],
            "assigning variable tau_N", stan::model::index_uni(sym1__));
          current_statement__ = 5;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, tau_N);
      Eigen::Matrix<local_scalar_t__,-1,-1> L_Omega =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_k, n_k,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> L_Omega_flat__;
        current_statement__ = 6;
        L_Omega_flat__ = context__.vals_r("L_Omega");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
          current_statement__ = 6;
          for (int sym2__ = 1; sym2__ <= n_k; ++sym2__) {
            current_statement__ = 6;
            stan::model::assign(L_Omega, L_Omega_flat__[(pos__ - 1)],
              "assigning variable L_Omega", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 6;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write_free_cholesky_factor_corr(L_Omega);
      Eigen::Matrix<local_scalar_t__,-1,1> rho =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_k, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> rho_flat__;
        current_statement__ = 7;
        rho_flat__ = context__.vals_r("rho");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
          current_statement__ = 7;
          stan::model::assign(rho, rho_flat__[(pos__ - 1)],
            "assigning variable rho", stan::model::index_uni(sym1__));
          current_statement__ = 7;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(rho);
      local_scalar_t__ mu_rho = DUMMY_VAR__;
      current_statement__ = 8;
      mu_rho = context__.vals_r("mu_rho")[(1 - 1)];
      out__.write(mu_rho);
      local_scalar_t__ sigma_rho = DUMMY_VAR__;
      current_statement__ = 9;
      sigma_rho = context__.vals_r("sigma_rho")[(1 - 1)];
      out__.write_free_lb(0, sigma_rho);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"delta", "sigma_delta", "eps",
                "alpha", "tau_N", "L_Omega", "rho", "mu_rho", "sigma_rho"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"mu", "tau", "bias", "prev_mean"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"Corr"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    n_i)},
                std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(n_i),
                  static_cast<size_t>(n_k)},
                std::vector<size_t>{static_cast<size_t>(n_k)},
                std::vector<size_t>{static_cast<size_t>(n_k)},
                std::vector<size_t>{static_cast<size_t>(n_k),
                  static_cast<size_t>(n_k)},
                std::vector<size_t>{static_cast<size_t>(n_k)},
                std::vector<size_t>{}, std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n_k)},
             std::vector<size_t>{static_cast<size_t>(n_k)},
             std::vector<size_t>{static_cast<size_t>(n_i),
               static_cast<size_t>(n_k)},
             std::vector<size_t>{static_cast<size_t>(n_i),
               static_cast<size_t>(n_k)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n_k),
               static_cast<size_t>(n_k)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= n_i; ++sym1__) {
      param_names__.emplace_back(std::string() + "delta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_delta");
    for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= n_i; ++sym2__) {
        param_names__.emplace_back(std::string() + "eps" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
      param_names__.emplace_back(std::string() + "tau_N" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= n_k; ++sym2__) {
        param_names__.emplace_back(std::string() + "L_Omega" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
      param_names__.emplace_back(std::string() + "rho" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "mu_rho");
    param_names__.emplace_back(std::string() + "sigma_rho");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
        param_names__.emplace_back(std::string() + "tau" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_i; ++sym2__) {
          param_names__.emplace_back(std::string() + "bias" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_i; ++sym2__) {
          param_names__.emplace_back(std::string() + "prev_mean" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_k; ++sym2__) {
          param_names__.emplace_back(std::string() + "Corr" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= n_i; ++sym1__) {
      param_names__.emplace_back(std::string() + "delta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_delta");
    for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= n_i; ++sym2__) {
        param_names__.emplace_back(std::string() + "eps" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
      param_names__.emplace_back(std::string() + "tau_N" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= ((n_k * (n_k - 1)) / 2); ++sym1__) {
      param_names__.emplace_back(std::string() + "L_Omega" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
      param_names__.emplace_back(std::string() + "rho" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "mu_rho");
    param_names__.emplace_back(std::string() + "sigma_rho");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
        param_names__.emplace_back(std::string() + "tau" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_i; ++sym2__) {
          param_names__.emplace_back(std::string() + "bias" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_i; ++sym2__) {
          param_names__.emplace_back(std::string() + "prev_mean" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_k; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_k; ++sym2__) {
          param_names__.emplace_back(std::string() + "Corr" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_i) + "},\"block\":\"parameters\"},{\"name\":\"sigma_delta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eps\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_i) + ",\"cols\":" + std::to_string(n_k) + "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_k) + "},\"block\":\"parameters\"},{\"name\":\"tau_N\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_k) + "},\"block\":\"parameters\"},{\"name\":\"L_Omega\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_k) + ",\"cols\":" + std::to_string(n_k) + "},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_k) + "},\"block\":\"parameters\"},{\"name\":\"mu_rho\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_rho\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_k) + "},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_k) + "},\"block\":\"transformed_parameters\"},{\"name\":\"bias\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_i) + ",\"cols\":" + std::to_string(n_k) + "},\"block\":\"transformed_parameters\"},{\"name\":\"prev_mean\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_i) + ",\"cols\":" + std::to_string(n_k) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Corr\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_k) + ",\"cols\":" + std::to_string(n_k) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_i) + "},\"block\":\"parameters\"},{\"name\":\"sigma_delta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eps\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_i) + ",\"cols\":" + std::to_string(n_k) + "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_k) + "},\"block\":\"parameters\"},{\"name\":\"tau_N\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_k) + "},\"block\":\"parameters\"},{\"name\":\"L_Omega\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(((n_k * (n_k - 1)) /2)) + "},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_k) + "},\"block\":\"parameters\"},{\"name\":\"mu_rho\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_rho\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_k) + "},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_k) + "},\"block\":\"transformed_parameters\"},{\"name\":\"bias\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_i) + ",\"cols\":" + std::to_string(n_k) + "},\"block\":\"transformed_parameters\"},{\"name\":\"prev_mean\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_i) + ",\"cols\":" + std::to_string(n_k) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Corr\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_k) + ",\"cols\":" + std::to_string(n_k) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((((n_i + 1) + (n_i * n_k)) + n_k) + n_k)
      + (n_k * n_k)) + n_k) + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * ((((n_k +
      n_k) + (n_i * n_k)) + (n_i * n_k)));
    const size_t num_gen_quantities = emit_generated_quantities * ((n_k *
      n_k));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((((n_i + 1) + (n_i * n_k)) + n_k) + n_k)
      + (n_k * n_k)) + n_k) + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * ((((n_k +
      n_k) + (n_i * n_k)) + (n_i * n_k)));
    const size_t num_gen_quantities = emit_generated_quantities * ((n_k *
      n_k));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_Correlated_x_namespace::model_Correlated_x;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_Correlated_x_namespace::profiles__;
}
#endif
#endif
