% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral.R
\name{spec_clust}
\alias{spec_clust}
\title{Spectral clustering (fast)}
\usage{
spec_clust(
  A,
  K,
  type = "lap",
  tau = 0.25,
  nstart = 20,
  niter = 10,
  ignore_first_col = FALSE
)
}
\arguments{
\item{A}{Adjacency matrix (n x n)}

\item{K}{Number of communities}

\item{type}{("lap" | "adj" | "adj2") Whether to use Laplacian or adjacency-based spectral clustering}

\item{tau}{Regularization parameter for the Laplacian}

\item{nstart}{argument from function 'kmeans'}

\item{niter}{argument from function 'kmeans'}

\item{ignore_first_col}{whether to ignore the first eigen vector when doing spectral clustering}
}
\value{
A label vector of size n x 1 with elements in {1,2,...,K}
}
\description{
Perform spectral clustering (with regularization) to estimate communities
}
\keyword{comm_detect}
