% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R
\name{simulate_roc}
\alias{simulate_roc}
\title{Simulate data to estimate ROC curves}
\usage{
simulate_roc(
  apply_methods,
  gen_null_data,
  gen_alt_data,
  nruns = 100,
  core_count = parallel::detectCores() - 1,
  seed = NULL
)
}
\arguments{
\item{apply_methods}{a function that returns a data.frame with columns
"method", "tstat" and "twosided"}

\item{gen_null_data}{a function that generate data under the null model}

\item{gen_alt_data}{a function that generate data under the alternative model}

\item{nruns}{number of simulated data from the null/alternative model}

\item{core_count}{number of cores used in parallel computing}

\item{seed}{seed for random simulation}
}
\value{
a list of result \item{roc}{A data frame used to plot ROC curves with
columns: method, whether a two sided test, false positive rate (FPR), and
true positive rate (TPR)} \item{raw}{A data frame containing raw output
from null and alternative models with columns: method, statistics value,
whether a two sided test, and the type of hypothesis}
\item{elapsed_time}{symstem elapsed time for generating ROC data}
}
\description{
Simulate data from the null and alternative distributions to estimate ROC
curves for a collection of methods.
}
\keyword{evaluation}
