% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{eval_dcsbm_bic}
\alias{eval_dcsbm_bic}
\title{Compute BIC score}
\usage{
eval_dcsbm_bic(A, z, K, poi)
}
\arguments{
\item{A}{adjacency matrix}

\item{z}{label vector}

\item{K}{number of community in \code{z}}

\item{poi}{whether to use Poisson version of likelihood}
}
\value{
BIC score
}
\description{
compute BIC score when fitting a DCSBM to network data
}
\details{
the BIC score is calculated by -2*log likelihood minus \eqn{K\times(K + 1)\times log(n)}
}
\section{References}{

BIC score is originally proposed in
\href{https://projecteuclid.org/euclid.aos/1494921948}{Likelihood-based model selection for stochastic block models}
Wang, YX Rachel, Peter J. Bickel, The Annals of Statistics 45, no. 2 (2017): 500-528.

The details of modified implementation can be found in
\href{https://arxiv.org/abs/2012.15047}{Adjusted chi-square test for degree-corrected block models},
Linfan Zhang, Arash A. Amini, arXiv preprint arXiv:2012.15047, 2020.
}

\seealso{
\link{eval_dcsbm_like}, \link{eval_dcsbm_loglr}
}
\keyword{mod_sel}
