% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_in.R
\name{nest_in}
\alias{nest_in}
\title{Create a nested structure}
\usage{
nest_in(
  x,
  ...,
  prefix = "",
  suffix = "",
  distinct = FALSE,
  leading0 = FALSE,
  compact = TRUE,
  keyname = NULL
)
}
\arguments{
\item{x}{A vector where each entry is the level of a parent. It may
be a factor or character. If character, levels are ordered alphanumerically.}

\item{...}{A single integer, character vector or sequence of
two-sided formula. If a single integer or character vector then each parent will have
children specified by the given value. If it is sequence of two-sided formula, then the left hand
side (LHS) specifies the level as an integer or character. E.g. \code{1}
means the first level of the parent vector. If it is a
character then it is assumed that it corresponds to the label of
the parental level. Vector is supported for LHS.
The right hand side (RHS) can only be an integer or a character vector.}

\item{prefix}{The prefix for the child labels.}

\item{suffix}{The suffix for the child labels.}

\item{distinct}{A logical value to indicate whether the child labels
across parents should be distinct. The labels are only
distinct if the RHS of the formula is numeric.}

\item{leading0}{By default it is \code{FALSE}. If \code{TRUE}, this is the
same as setting \code{0} or \code{1}. If a positive integer is
specified then it corresponds to the minimum number of digits
for the child labels and there will be leading zeros augmented so
that the minimum number is met.}

\item{compact}{A logical value to indicate whether the returned list
should be a compact representation or not. Ignored if distinct is \code{TRUE}
since it's not possible to make compact representation if unit labels
are all distinct.}

\item{keyname}{The name of the parent variable. It's usually the key
that connects the output to another table.}
}
\value{
A named list where the entry corresponding to the child levels
and the names correspond to parental levels.
}
\description{
This function results in a two column data frame with nested structure.
Currently only one parent is supported and child is only specified by
giving the number of levels. (This will change shortly).
}
\examples{
# Each element in the supplied the vector has 4 child.
nest_in(1:3, 4)

# prefix and suffix can be added to child labels
# along with other aesthesitics like leading zeroes
# with minimum number of digits.
nest_in(1:3, 10, prefix = "id-", suffix = "xy", leading0 = 4)

# you can specify unbalanced nested structures
nest_in(2:4,
         1 ~ 3,
         2 ~ 4,
         3 ~ 2)

# A `.` may be used to specify "otherwise".
nest_in(c("A", "B", "C", "D"),
             2:3 ~ 10,
               . ~ 3)

# The parental level can be referred by its name or vectorised.
nest_in(c("A", "B", "C"),
         c("A", "B") ~ 10,
                 "C" ~ 3)

}
