% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{npe_site_ids}
\alias{npe_site_ids}
\title{Get site ids}
\usage{
npe_site_ids(by, domain = NA, type = NA, aridity = NA, koppen = NA)
}
\arguments{
\item{by}{How to select sites? Can be "all", "domain", "ai", "koppen", or "type".}

\item{domain}{can be one or more domain codes, as a character vector, or as a number.
e.g. domain = c("D01", "D14"), or domain = c(3, 14), can also be a mix: domain = c(3, "D04).}

\item{type}{can be "Core Terrestrial" or "Relocatable Terrestrial"}

\item{aridity}{can be "Hyper-Arid", "Arid", "Dry sub-humid", or "Humid"}

\item{koppen}{can be any 3 letter Koppen-Geiger code, or one of "Equatorial", "Arid", "Temperate", "Boreal", "Polar"}
}
\value{
a vector of four letter site identification codes.
}
\description{
This returns a list of 4 letter site ID codes to feed into npe_download. It can return
all 47 siteID codes, or a subset based on site type, aridity index, Koppen-Geiger
Climate region, or NEON domain.
}
\examples{
all_sites <- npe_site_ids(by = "all")
npe_site_ids(by = "domain", domain = c("Northeast", "Mid-Atlantic"))
npe_site_ids(by = "domain", domain = c("D02", 15))

}
