% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{countries}
\alias{countries}
\title{Countries from naturalearth}
\usage{
countries(
  name = NA,
  part = FALSE,
  dependency = FALSE,
  indeterminate = FALSE,
  exclude = NULL,
  include = NULL,
  utm = FALSE,
  crs = NULL,
  towns = FALSE,
  capital = FALSE,
  lang = NULL,
  extend = 1,
  shift = FALSE,
  coastlines = TRUE
)
}
\arguments{
\item{name}{a character vector that contains one or several
countries, regions or subregions (mixing the two of the three
cathegories will result as an error),}

\item{part}{should the parts of the countries be included (eg
Azsores for Portugal or Alaska for the United States of
America),}

\item{dependency}{should the dependencies of the countries be
included (eg Greenland and the Faroe Islands for Denmark),}

\item{indeterminate}{should the indeterminate territories be
included,}

\item{exclude}{an optional set of countries that should be excluded
from the request,}

\item{include}{an optional set of countries that should be included}

\item{utm}{if \code{TRUE}, the geometry is transformed using the
relevant utm projection, if an integer, the geometry is
transformed using the utm projection for the zone indicated,}

\item{crs}{a CRS}

\item{towns}{if \code{TRUE}, a tibble containing the cities of the
countries selected is returned as a \code{"towns"} attribute,}

\item{capital}{if \code{TRUE} the tibble containing the cities of the
countries selected will contain the capitals, whatever their
size,}

\item{lang}{the language for countries and towns, one of \code{"en"},
\code{"fr"}, \code{"es"}, `"it"}

\item{extend}{a number >= 1, extend the bounding box so that the
background is larger than the initial bounding box and can be
transformed correctly if utm transformation is required}

\item{shift}{a boolean, if \code{TRUE}, \code{st_shift_longitude} is used}

\item{coastlines}{a boolean, \code{TRUE} to get the background coastines}
}
\value{
an object of class \code{countries} which inherits from \code{sf}
with the following columns:
\itemize{
\item \code{id} the two letters identifier of the country,
\item \code{type} either \code{"main"} (the main part of a sovereign country, the
whole country for most of them) - \code{country} the name of the
entity,
\item \code{sovereign} the sovereign country the entity belongs to,
\item \code{capital} the name of the capital of the country (NA for parts
and dependencies) - \code{subregion} the name of the subregion
(United Nations' definition)
\item \code{pop} the population of the entity,
\item \code{gdp} currently undocumented
\item \code{wbreg} the name of the region (World Bank's definition)
\item \code{region} the name of the region (United Nations' definition) Two
attributes \code{"type"} and \code{"towns"}
}
}
\description{
Select a set of countries; talking about countries, we mean either
sovereign countries, parts of countries and dependencies, each of
these cathegories being on each own row. A single or a set of
countries can be obtained by indicating a set of names of, either
countries, regions or subregions
}
\examples{
countries("Western Europe")
}
