% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_filter.R
\name{grid_filter}
\alias{grid_filter}
\title{Filter the occurrence with most confidence in species identification inside
grid cells}
\usage{
grid_filter(
  occ.cl,
  grid.resolution = c(0.5, 0.5),
  r = NULL,
  institution.code = "institutionCode",
  collection.code = "collectionCode",
  catalog.number = "catalogNumber",
  year = "year",
  date.identified = "dateIdentified",
  species = "species",
  identified.by = "identifiedBy",
  decimal.latitude = "decimalLatitude",
  decimal.longitude = "decimalLongitude",
  basis.of.record = "basisOfRecord",
  media.type = "mediaType",
  occurrence.id = "occurrenceID",
  institution.source,
  year.event,
  scientific.name,
  determined.by,
  latitude,
  longitude,
  basis.of.rec,
  occ.id
)
}
\arguments{
\item{occ.cl}{data frame with occurrence records information already
classified by \code{\link{classify_occ}} function.}

\item{grid.resolution}{numeric vector with width and height of grid cell in
decimal degrees.}

\item{r}{raster from which the grid cell resolution is derived.}

\item{institution.code}{column name of \code{occ.cl} with the name (or acronym)
in use by the institution having custody of the object(s) or information
referred to in the record.}

\item{collection.code}{column name of \code{occ.cl} with The name, acronym,
code, or initials identifying the collection or data set from which the
record was derived.}

\item{catalog.number}{column name of \code{occ.cl} with an identifier
(preferably unique) for the record within the data set or collection.}

\item{year}{Column name of \code{occ.cl} the four-digit year in which the
Event occurred, according to the Common Era Calendar.}

\item{date.identified}{Column name of \code{occ.cl} with the date on which the
subject was determined as representing the Taxon.}

\item{species}{column name of \code{occ} with the species names.}

\item{identified.by}{column name of \code{occ.cl} with the name of who
determined the species.}

\item{decimal.latitude}{column name of \code{occ.cl} latitude in decimal
degrees.}

\item{decimal.longitude}{column name of \code{occ.cl} longitude in decimal
degrees.}

\item{basis.of.record}{column name with the specific nature of the data
record. See details.}

\item{media.type}{column name of \code{occ.cl} with the media type of recording.
See details.}

\item{occurrence.id}{column name of \code{occ} with link or code for the
occurrence record. See in
\href{https://dwc.tdwg.org/terms/#dwc:occurrenceID}{Darwin Core Format}}

\item{institution.source}{deprecated, use \code{institution.code} instead.}

\item{year.event}{deprecated, use \code{year} instead.}

\item{scientific.name}{deprecated, use \code{species} instead.}

\item{determined.by}{deprecated, use \code{identified.by} instead}

\item{latitude}{deprecated, use \code{decimal.latitude} instead}

\item{longitude}{deprecated, use \code{decimal.longitude} instead}

\item{basis.of.rec}{deprecated, use \code{basis.of.record} instead.}

\item{occ.id}{deprecated, use \code{occurrence.id} instead}
}
\value{
Data frame with the same columns of \code{occ.cl}.
}
\description{
In each grid cell it selects the occurrence with the highest confidence level
in species identification made by \code{\link{classify_occ}} function.
}
\examples{

\dontrun{

data("A.setosa")
data("speciaLists")

occ.class <- classify_occ(A.setosa, speciaLists)
occ.grid <- grid_filter(occ.class)

}




}
\seealso{
\code{\link[naturaList]{classify_occ}}
}
\author{
Arthur V. Rodrigues
}
