% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extdata.R
\name{find_extdata}
\alias{find_extdata}
\title{Construct paths to files in the extdata folder of a package}
\usage{
find_extdata(..., package = NULL, firstpath = NULL, Verbose = FALSE)
}
\arguments{
\item{...}{components of the path (eventually appended to location of
\code{extdata})}

\item{package}{The package to search}

\item{firstpath}{An additional location to check before looking anywhere else}

\item{Verbose}{Whether to print messages about failed paths while looking for
extdata}
}
\value{
A character vector containing the constructed path
}
\description{
Construct paths to files in the extdata folder of a package
}
\details{
\code{inst/extdata} is the conventional place to store data that is
  not managed directly by the standard R package mechanisms. Unfortunately
  its location changes at different stages of the package build/load process,
  since in the final  package all folders underneath \code{inst} are moved
  directly to the package root.
}
\examples{
find_extdata(package='nat.utils')
}
\seealso{
Other extdata: 
\code{\link{read_nl_from_parts}()},
\code{\link{save_nl_in_parts}()}
}
\concept{extdata}
