% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss-x-summary.R
\name{miss_summary}
\alias{miss_summary}
\title{Collate summary measures from naniar into one tibble}
\usage{
miss_summary(data, order = TRUE)
}
\arguments{
\item{data}{a dataframe}

\item{order}{whether or not to order the result by n_miss}
}
\value{
a tibble of missing data summaries
}
\description{
\code{miss_summary} performs all of the missing data helper summaries and puts
them into lists within a tibble
}
\examples{

s_miss <- miss_summary(airquality)
s_miss$miss_df_prop
s_miss$miss_case_table
s_miss$miss_var_summary
# etc, etc, etc.

\dontrun{
library(dplyr)
s_miss_group <- group_by(airquality, Month) \%>\% miss_summary()
s_miss_group$miss_df_prop
s_miss_group$miss_case_table
# etc, etc, etc.
}

}
\seealso{
\code{\link[=pct_miss_case]{pct_miss_case()}} \code{\link[=prop_miss_case]{prop_miss_case()}} \code{\link[=pct_miss_var]{pct_miss_var()}} \code{\link[=prop_miss_var]{prop_miss_var()}} \code{\link[=pct_complete_case]{pct_complete_case()}} \code{\link[=prop_complete_case]{prop_complete_case()}} \code{\link[=pct_complete_var]{pct_complete_var()}} \code{\link[=prop_complete_var]{prop_complete_var()}} \code{\link[=miss_prop_summary]{miss_prop_summary()}} \code{\link[=miss_case_summary]{miss_case_summary()}} \code{\link[=miss_case_table]{miss_case_table()}} \code{\link[=miss_summary]{miss_summary()}} \code{\link[=miss_var_prop]{miss_var_prop()}} \code{\link[=miss_var_run]{miss_var_run()}} \code{\link[=miss_var_span]{miss_var_span()}} \code{\link[=miss_var_summary]{miss_var_summary()}} \code{\link[=miss_var_table]{miss_var_table()}} \code{\link[=n_complete]{n_complete()}} \code{\link[=n_complete_row]{n_complete_row()}} \code{\link[=n_miss]{n_miss()}} \code{\link[=n_miss_row]{n_miss_row()}} \code{\link[=pct_complete]{pct_complete()}} \code{\link[=pct_miss]{pct_miss()}} \code{\link[=prop_complete]{prop_complete()}} \code{\link[=prop_complete_row]{prop_complete_row()}} \code{\link[=prop_miss]{prop_miss()}}
}
