% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mws_main.R
\name{mwsApp}
\alias{mwsApp}
\title{Runs Shiny app in multiple specified windows.}
\usage{
mwsApp(ui_win = list(), serv_calc = list(), serv_out = list())
}
\arguments{
\item{ui_win}{named list of shiny UI pages. The name of each entry in the UI page list corresponds to its window title. No windows can be named 'WindowSelector', titles must be uniquely named, and titles cannot have spaces.}

\item{serv_calc}{a named list of functions that calculate variables derived from user input, to be used in rendering output. Each function is of the form function(calc, session), where calc is a named list containing the traditional Shiny input and user-created reactive values, and session is the traditional Shiny server session value. All calculated variables that are needed to render output should be added, named, to the calc list. When using reactive functions such as observeEvent(), each should be contained in a separate function, and variables dependent on these reactions should be added to calc. Note that these functions follow all Shiny conventions (reactive values must be accessed in a reactive context, etc.).}

\item{serv_out}{a named list of functions that render output. Each function is of the form function(calc, session), where calc is a named list containing the traditional Shiny input and reactive values that have calculated values derived from input, and session is the traditional Shiny server session value. It returns the results of a Shiny render function. The name of each function corresponds to its output label. Note that these functions follow all Shiny conventions (reactive values must be accessed in a reactive context, etc.).}
}
\value{
Shiny app object (i.e., it runs the app)
}
\description{
Runs Shiny app in multiple specified windows.
}
\examples{
if(interactive()){
# Run a simple 2-window app, initially bringing up the window selector window:
ui_win <- list()
ui_win[["clickinput"]] <- fluidPage(numericInput(inputId = "click", label = "a", value = 1))
ui_win[["clickoutput"]] <- fluidPage(plotOutput("clickplot"))
serv_out <- list()
serv_out[["clickplot"]] <- function(calc, session){
  renderPlot({
      plot(1:calc$click,1:calc$click)
  })
}
mwsApp(ui_win, list(), serv_out)
}
}
