% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalk_lakes_by_state.R
\name{state_crosswalks}
\alias{state_crosswalks}
\alias{nhdhr_to_wi}
\alias{lagos_to_mi}
\alias{mn_to_mglp}
\title{Crosswalk lake identifiers to/from specific states}
\usage{
nhdhr_to_wi(data, from_colname = "nhdhr.id", agency = NULL)

lagos_to_mi(data, from_colname = "lagos.id", agency = NULL, id_field = NULL)

mn_to_mglp(data, from_colname, agency = NULL)
}
\arguments{
\item{data}{A data.set with a column containing a lake identifier
corresponding to one of the datasets listed above (also see lake_id_xref)}

\item{from_colname}{Character. The column name in \code{data} that lake IDs
that are being converted from (e.g. \code{data} has a lake ID column that
you are trying to convert from -- what is the name of that column)}

\item{agency}{Optional character vector specifying the agency to use for
the local ID column. This is helpful if data exist in lake_id_xref for
which there are more than one agency in a state that provided data}

\item{id_field}{Optional character vector specifying the id.field to use
for the local ID column. Occasionally states use more than one identifier.
This allows explicit choice of which identifier to use.}
}
\value{
A data.frame the same as \code{data}, but with an additional
lake identification column from lake_id_xref
}
\description{
State specific functions to be used as handy shortcuts.
(i.e. you can call a state's function directly rather than specifying
\code{local_to_*} or \code{*_to_local} with the state as an argument.
One of these functions exists for all combinations of both states and lake
ID columns found in \code{lake_id_xref}. For a full list of these functions,
see ?all_state_crosswalks
}
\examples{
wi_to_nhdhr(wis_lakes, from_colname = "lake.id")
}
