\name{print.mvout}
\alias{print.mvout}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Print method for Robust Multivariate Outlier Detection
}
\description{
\code{print} method for class "mvout".
}
\usage{
\method{print}{mvout}(x, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
Object of class \code{mvout}
}
  \item{...}{
Additional arguments (ignored).
}
}
\details{
Prints the percentage of observations flagged as outliers, five quantiles of the robust Mahalanobis distances, and basic information about the options used for the outlier detection.
}
\value{
Nothing returned (just prints to console).
}
%\references{
%Delgado, J. E., Elison, J. T., & Helwig, N. E. (2025). Robust Detection of Signed Outliers in Multivariate Data With Applications to
%Early Identification of Risk for Autism. Psychological Methods. (conditionally accepted)
%}
\author{
Jesus E. Delgado <delga220@umn.edu>
Nathaniel E. Helwig <helwig@umn.edu>
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{mvout}} for estimation of (robust) location/scatter.

\code{\link{predict.mvout}} for obtaining predictions from \code{mvout} objects.
}
\examples{
# generate some data
n <- 200
p <- 2
set.seed(0)
x <- matrix(rnorm(n * p), n, p)

# detect outliers
set.seed(1)    # for reproducible MCD estimate
out <- mvout(x)

# print results
out
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
\keyword{ print }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
