% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_theory.R
\name{tnprime}
\alias{tnprime}
\title{Transposition class of a given pc-set}
\usage{
tnprime(set, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric vector of same length as \code{set} representing the set's
Tn-prime form
}
\description{
Uses Rahn's algorithm to calculate the best normal order for the
transposition class represented by a given set. Reflects transpositional
but not inversional equivalence, i.e. all major triads return (0, 4, 7) and
all minor triads return (0, 3, 7).
}
\examples{
tnprime(c(2, 6, 9))
tnprime(c(0, 3, 6, 9, 14), edo=16)
}
