% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realize_stepword.R
\name{realize_stepword}
\alias{realize_stepword}
\title{Define scale by entering its relative step sizes}
\usage{
realize_stepword(stepword, edo = 12, reconvert = TRUE)
}
\arguments{
\item{stepword}{A numeric vector (intended to be nonnegative integers) of ranked step
sizes; should be the same length as desired output set.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{reconvert}{Boolean. Should the result be expressed measured in
terms of semitones (or a different mod k step if edo is not set to 12)?}
}
\value{
Numeric vector of same length as set, if \code{reconvert} is \code{TRUE}. If
\code{reconvert} is \code{FALSE}, returns a list with two elements. The first
element (\code{set}) expresses the defined set as integer values in some edo.
The second element (\code{edo}) tells you which edo (mod k universe) the set
is defined in.
}
\description{
Where \code{\link[=asword]{asword()}} takes you from a scale to a ranked list of its step sizes,
\code{realize_stepword} does the opposite: given a list of ranked step sizes,
it defines a scale with those steps. It does not attempt to define a scale
that exists in 12-tone equal temperament or another mod k universe, though
the result will have integral values in \emph{some} mod k setting. If you
want that information, set \code{reconvert} to \code{FALSE}.
}
\examples{
dim7 <- realize_stepword(c(1, 1, 1, 1))
four_on_the_floor <- realize_stepword(c(1, 1, 1, 1), edo=16)
my_luggage <- realize_stepword(c(1, 2, 3, 4, 5))
my_luggage_in_15edo <- realize_stepword(c(1, 2, 3, 4, 5), reconvert=FALSE)
dim7
four_on_the_floor
my_luggage
my_luggage_in_15edo

pwf_scale <- realize_stepword(c(3, 2, 1, 3, 2, 3, 1))
asword(pwf_scale)

}
