% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sMLE.R
\name{sMLE}
\alias{sMLE}
\title{Short-term maximum Lyapunov exponents}
\usage{
sMLE(synergies, mean_period, future_pts, norm, pts, R2_threshold = 0.9)
}
\arguments{
\item{synergies}{A \code{musclesyneRgies} object}

\item{mean_period}{To locate the nearest neighbour of each point on the state space
trajectory}

\item{future_pts}{To limit the number of points "in the future" that are being searched}

\item{norm}{Type of normalisation ("u" for minimum subtraction and normalisation to the maximum,
"z" for subtracting the mean and then divide by the standard deviation)}

\item{pts}{Minimum number of points needed to linearly approximate the first part
of the divergence curve}

\item{R2_threshold}{Threshold for calculating the slope of the divergence curve}
}
\value{
A list with elements:\cr
\itemize{
\item \code{divergences} containing the average logarithmic divergence curve\cr
\item \code{sMLE} the short-term Maximum Lyapunov exponent\cr
\item \code{R2} the goodness of fit of the most linear part of the divergence curve
}
}
\description{
Short-term maximum Lyapunov exponents
}
\details{
The mean period is intended to exclude temporally close points. In gait, values are usually
plus/minus half gait cycle. Future points usually correspond in gait to one to two gait cycles.
Please consider that a sufficient amount of cycles in order to compute meaningful sMLE.
For locomotor primitives, 30 gait cycles have been shown to be sensitive to perturbations
(Santuz et al. 2020). However, in the more classical and widespread use on kinematic data,
more are usually needed (Kang and Dingwell, 2006).
}
\examples{
# Load some primitives
data("primitives")
# Calculate sMLE of motor primitives in the muscle synergy space
short_term_MLE <- sMLE(primitives,
  mean_period = 80,
  future_pts = 200,
  norm = "z",
  pts = 30
)
}
\references{
Rosenstein, M.T., Collins, J.J., and De Luca, C.J. (1993).
A practical method for calculating largest Lyapunov exponents from small data sets.
Phys. D 65, 117–134.\cr

Santuz A, Brüll L, Ekizos A, Schroll A, Eckardt N, Kibele A, et al.
Neuromotor Dynamics of Human Locomotion in Challenging Settings.
iScience. 2020;23: 100796.\cr

Kang H.G., and Dingwell J.B. (2006).
Intra-session reliability of local dynamic stability of walking.
Gait Posture. 24(3) 386-390.
}
