% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifier.R
\name{rank_score}
\alias{rank_score}
\title{Calculate Rank Score for Predictions}
\usage{
rank_score(prob, observed)
}
\arguments{
\item{prob}{Numeric matrix of predicted probabilities (observations x classes).
Column names must correspond to class labels.}

\item{observed}{Factor or vector of observed class labels. Must be present in \code{colnames(prob)}.}
}
\value{
A \code{data.frame} with columns \code{prank} (the normalized rank score) and \code{observed} (the input labels).
}
\description{
Computes the rank score (normalized rank of the true class probability) for each observation.
Lower rank scores indicate better predictions (true class has higher probability).
}
\examples{
probs <- matrix(c(0.1, 0.9, 0.8, 0.2), 2, 2, byrow=TRUE,
               dimnames = list(NULL, c("A", "B")))
obs <- factor(c("B", "A"))
rank_score(probs, obs)
}
\seealso{
Other classifier evaluation: 
\code{\link{topk}()}
}
\concept{classifier evaluation}
