make_data <- function(){

  data.frame(
    id   = 1:500,
    iv1  = rnorm(500),
    iv2  = rnorm(500),
    iv3  = rnorm(500),
    mod1 = rnorm(500),
    mod2 = rnorm(500),
    mod3 = rnorm(500),
    cov1 = rnorm(500),
    cov2 = rnorm(500),
    dv1  = rnorm(500),
    dv2  = rnorm(500),
    include1 = rbinom(500, size = 1, prob = .1),
    include2 = sample(1:3, size = 500, replace = TRUE),
    include3 = rnorm(500)
  )

}

make_pipeline <- function(the_data){

  the_data |>
    add_filters(include1 == 0, include2 != 3, include2 != 2, include3 > -2.5) |>
    add_variables("ivs", iv1, iv2, iv3) |>
    add_variables("dvs", dv1, dv2) |>
    add_variables("mods", starts_with("mod"))

}
