% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-examples.R
\name{example_smk_re}
\alias{example_smk_re}
\title{Example smoking RE NMA}
\description{
Calling \code{example("example_smk_re")} will run a random effects
NMA model with the smoking cessation data, using the code in the Examples
section below. The resulting \code{stan_nma} object \code{smk_fit_RE} will then be
available in the global environment.
}
\details{
Smoking RE NMA for use in examples.
}
\examples{
# Set up network of smoking cessation data
head(smoking)

smk_net <- set_agd_arm(smoking,
                       study = studyn,
                       trt = trtc,
                       r = r,
                       n = n,
                       trt_ref = "No intervention")

# Print details
smk_net

\donttest{
# Fitting a random effects model
smk_fit_RE <- nma(smk_net, 
                  trt_effects = "random",
                  prior_intercept = normal(scale = 100),
                  prior_trt = normal(scale = 100),
                  prior_het = normal(scale = 5))

smk_fit_RE
}

\dontshow{
if (requireNamespace("pkgdown", quietly = TRUE) && pkgdown::in_pkgdown()) {
  assign("smk_net", smk_net, .GlobalEnv)
  assign("smk_fit_RE", smk_fit_RE, .GlobalEnv)
}
}
}
\keyword{examples}
