% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{parallelize}
\alias{parallelize}
\title{Parallelize Estimation across Responses}
\usage{
parallelize(f, progress = TRUE)
}
\arguments{
\item{f}{A function for estimating a single response model given a formula
and input dataset. This is the model that we would like to parallelize
across responses.}

\item{progress}{A logical indicating whether to show a progress bar.}
}
\value{
f_multi A function that takes a formula and dataset and applies f to
each response on the left hand side of the original formula.
}
\description{
For many mediation and outcome models, we simply want to apply a univariate
model across all response variable. Parallelize enables this conversion. For
example, applying parallelize to ranger() returns a function that estimates
separate random forest models for each response on the left hand side of a
formula.
}
\examples{
mat <- data.frame(matrix(rnorm(100), 25, 4))
colnames(mat) <- c("y1", "y2", "x1", "x2")
plm <- parallelize(lm)
plm(y1 + y2 ~ x1 + x2, mat)

prf <- parallelize(ranger::ranger)
prf(mpg + hp ~ wt + disp + cyl, data = mtcars)
}
