% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substitution.R
\name{substitution}
\alias{substitution}
\title{Multilevel Compositional Substitution Analysis}
\usage{
substitution(
  object,
  delta,
  ref = c("grandmean", "clustermean"),
  level = c("between", "within", "aggregate"),
  summary = TRUE,
  at = NULL,
  parts = 1,
  base,
  type,
  weight = c("equal", "proportional"),
  scale = c("response", "linear"),
  aorg = NULL,
  cores = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted \code{\link{brmcoda}} object.}

\item{delta}{A integer, numeric value or vector indicating the amount of substituted change between compositional parts.}

\item{ref}{Either a character value or vector or a dataset.
Can be \code{"grandmean"} and/or \code{"clustermean"}, or
a \code{data.frame} or \code{data.table} of user's specified reference grid consisting
of combinations of covariates over which predictions are made.
User's specified reference grid is only possible for simple substitution.
Single level models are default to \code{"grandmean"}.}

\item{level}{A character string or vector.
Should the estimate of multilevel models focus on the \code{"between"} and/or \code{"within"} or \code{"aggregate"} variance?
Single-level models are default to \code{"aggregate"}.}

\item{summary}{A logical value to obtain summary statistics instead of the raw values. Default is \code{TRUE}.
Currently only support outputing raw values for model using grandmean as reference composition.}

\item{at}{An optional named list of levels for the corresponding variables in the reference grid.}

\item{parts}{A optional character string specifying names of compositional parts that should be considered
in the substitution analysis. This should correspond to a single set of names of compositional parts specified
in the \code{complr} object. Default to the first composition in the \code{complr} object.}

\item{base}{An optional base substitution.
Can be a \code{data.frame} or \code{data.table} of the base possible substitution of compositional parts,
which can be computed using function \code{\link{build.base}}.}

\item{type}{A character string to indicate the type of substitution.
If \code{"one-to-all"}, all possible one-to-remaining reallocations are estimated.
If \code{"one-to-one"}, all possible one-to-one reallocations are estimated.
If \code{"equal"}, give equal weight to units (e.g., individuals).
If \code{"proportional"}, weights in proportion to the frequencies of units being averaged
(e.g., observations across individuals).
Default to \code{"equal"} for \code{ref = "grandmean"} and \code{"proportional"} for \code{ref = "clustermean"}.}

\item{weight}{A character value specifying the weight to use in calculation of the reference composition.}

\item{scale}{Either \code{"response"} or \code{"linear"}.
If \code{"response"}, results are returned on the scale of the response variable.
If \code{"linear"}, results are returned on the scale of the linear predictor term,
that is without applying the inverse link function or other transformations.}

\item{aorg}{Internal use. A logical value indicating whether the results should be average across reference grid.}

\item{cores}{Number of cores to use when executing the chains in parallel,
we recommend setting the \code{mc.cores} option
to be as many processors as the hardware and RAM allow (up to the number of compositional parts).
For non-Windows OS in non-interactive R sessions, forking is used instead of PSOCK clusters.
Default to \code{"one-to-one"}.}

\item{...}{Further arguments passed to \code{\link[brms:posterior_summary]{posterior_summary}}.}
}
\value{
A list containing the results of multilevel compositional substitution model.
The first six lists contain the results of the substitution estimation for a compositional part.
\item{\code{Mean}}{ Posterior means.}
\item{\code{CI_low} and \code{CI_high}}{ 95\% credible intervals.}
\item{\code{Delta}}{ Amount substituted across compositional parts.}
\item{\code{From}}{ Compositional part that is substituted from.}
\item{\code{To}}{ Compositional parts that is substituted to.}
\item{\code{Level}}{ Level where changes in composition takes place.}
\item{\code{Reference}}{ Either \code{grandmean}, \code{clustermean}, or \code{users}.}
}
\description{
Estimate the difference in an outcome
when compositional parts are substituted for specific unit(s).
The \code{substitution} output encapsulates
the substitution results for all compositional parts
present in the \code{\link{brmcoda}} object.
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){
  x <- complr(data = mcompd, sbp = sbp,
                 parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                 idvar = "ID", total = 1440)

  # model with compositional predictor at between and within-person levels
  m1 <- brmcoda(complr = x,
                  formula = Stress ~ bz1_1 + bz2_1 + bz3_1 + bz4_1 +
                                     wz1_1 + wz2_1 + wz3_1 + wz4_1 +
                                     Female + (1 | ID),
                  chain = 1, iter = 500, backend = "cmdstanr")

  # one to one reallocation at between and within-person levels
  sub1 <- substitution(object = m1, delta = 5, level = c("between"))
  summary(sub1)

  # one to all reallocation at between and within-person levels
  sub2 <- substitution(object = m1, delta = 5, level = c("between", "within"),
                       type = "one-to-all")
  summary(sub2)

  # model with compositional predictor at aggregate level
  m2 <- brmcoda(complr = x,
                  formula = Stress ~ z1_1 + z2_1 + z3_1 + z4_1 + (1 | ID),
                  chain = 1, iter = 500, backend = "cmdstanr")
  sub3 <- substitution(object = m2, delta = 5, level = c("aggregate"))

}}
}
