% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperfunctions_extract.R
\name{extract_components}
\alias{extract_components}
\title{Extract Model Components to be Compared}
\usage{
extract_components(model, dimnames)
}
\arguments{
\item{model}{multiFAMM model object from which to extract the information.}

\item{dimnames}{Names of the dimensions of the model.}
}
\value{
A list with the following elements
  \itemize{
    \item \code{error_var}: A list containing the following elements
      \itemize{
      \item \code{model_weights}: Model weights used in the final multiFAMM.
      \item \code{modelsig2}: Estimate of sigma squared in the final model.
      \item \code{uni_vars}: Univariate estimates of sigma squared.}
    \item \code{eigenvals}: List containing the estimated eigenvalues.
    \item \code{fitted_curves}: multiFunData object containing the fitted
      curves.
    \item \code{eigenfcts}: multiFunData object containing the estimated
      eigenfunctions.
    \item \code{cov_preds}: multiFunData object containing the estimated
      covariate effects.
    \item \code{ran_preds}: List containing multiFunData objects of the
      predicted random effects.
    \item \code{scores}: List containing matrices of the estimated scores.
    \item \code{meanfun}: multiFunData object containing the estimated mean
      function.
    \item \code{var_info}: List containing all eigenvalues and univariate
      norms before the MFPC pruning step
      \itemize{
      \item \code{eigenvals}: Vector of all multivariate eigenvalues.
      \item \code{uni_norms}: List of univariate norms of all
        eigenfunctions.}}
}
\description{
This is an internal function that helps to compare different models. The
models resulting from a multiFAMM() call are typically very big. This
function extracts the main information from a model so that a smaller R
object can be saved.
}
\details{
So far the grid is fixed to be on [0,1].
}
