% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicmpests.R
\name{dbivCMP}
\alias{dbivCMP}
\title{The Bivariate Conway-Maxwell-Poisson Distribution}
\usage{
dbivCMP(lambda, nu, bivprob, x, y, maxit)
}
\arguments{
\item{lambda}{Mean/rate parameter under Poisson model.}

\item{nu}{Dispersion parameter.}

\item{bivprob}{Bivariate probabilities, {p00, p01, p10, p11}.}

\item{x}{x values}

\item{y}{y values}

\item{maxit}{Number of terms used to truncate infinite sum calculations.}
}
\description{
Density for the Bivariate Conway-Maxwell-Poisson (CMP) distribution
}
\examples{
dbivCMP(lambda=10, nu=1, bivprob=c(0.4, 0.2, 0.3, 0.1), x=2, y=3, maxit = 100) 
#this is equivalent to the pmf P(X=2,Y=3) of a bivariate Poisson 
##with lambda1=3, lambda2=2, lambda3=1

}
\references{
Sellers KF, Morris DS, Balakrishnan N (2016) Bivariate Conway-Maxwell-Poisson Distribution: Formulation, Properties, and Inference, Journal of Multivariate Analysis 150:152-168.
}
