% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiRDPG.R
\name{multiRDPG}
\alias{multiRDPG}
\title{Fitting Multiple Random Dot Product Graphs}
\usage{
multiRDPG(A, d, maxiter = 100, tol = 1e-06)
}
\arguments{
\item{A}{List of adjacency matrices representing graphs. Each matrix must be symmetric. All matrices of the same size n x n.}

\item{d}{Dimension of latent space. d<= n.}

\item{maxiter}{Maximal number of iterations. Default is 100.}

\item{tol}{Tolerance for update of the objective function. Default is 1e-6.}
}
\value{
Returns a list of the following:\cr
\tabular{ll}{
            \code{U}         \tab Matrix of the joint vectors. n x d. \cr
            \code{Lambda}    \tab List of diagonal matrices. One for each graph. d x d.\cr
            \code{Converged} \tab Represent of the algorithm converged. 1 if converged, 0 if not.\cr
            \code{iter}      \tab Number of iterations \cr
            \code{maxiter}   \tab Maximal number of iterations.Default is 100.\cr
            \code{objfun}    \tab Value of the objective function. sum_k ||A^k - U Lambda U^T||_F^2
}
}
\description{
\code{multiRDPG} is used to fit Multiple Random Dot Product Graphs from a set of adjacency matrices.
}
\examples{
#simulate data
U <- matrix(0, nrow=20, ncol=3)
U[,1] <- 1/sqrt(20)
U[,2] <- rep(c(1,-1), 10)/sqrt(20)
U[,3] <- rep(c(1,1,-1,-1), 5)/sqrt(20)

L<-list(diag(c(11,6,2)),diag(c(15,4,1)))
A <- list()
for(i in 1:2){
  P <- U\%*\%L[[i]]\%*\%t(U)
  A[[i]] <-apply(P,c(1,2),function(x){rbinom(1,1,x)})
  A[[i]][lower.tri(A[[i]])]<-t(A[[i]])[lower.tri(A[[i]])]
}

#fit model
multiRDPG(A,3)


}
\seealso{
\code{\link{multiRDPG_test}}
}
\author{
Agnes Martine Nielsen (agni@dtu.dk)
}
