% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_selection_for_ML.R
\name{predict.multiDEGGs_filter_combined}
\alias{predict.multiDEGGs_filter_combined}
\title{Wrapper of .predict_multiDEGGs for multiDEGGs_filter_combined()}
\usage{
\method{predict}{multiDEGGs_filter_combined}(object, newdata, interaction.type = "ratio", sep = ":", ...)
}
\arguments{
\item{object}{A fitted object of class \code{multiDEGGs_filter} containing
filtering results with:
\describe{
\item{keep}{Character vector of variable names to keep as single
predictors}
\item{pairs}{Data frame or matrix with two columns specifying pairs
of variables to combine}
}}

\item{newdata}{A data frame containing the new data for prediction.
Must contain all variables specified in \code{object$keep} and
\code{object$pairs}.}

\item{interaction.type}{Character string specifying how to combine the
paired predictors.
Options are:
\describe{
\item{"ratio"}{Combine paired predictors by dividing the first variable
by the second (a/b)}
\item{other}{Combine paired predictors by multiplying the variables (a*b)
}
}
Default is "ratio".}

\item{sep}{Character string used as separator when creating column names for
combined predictors. Default is ":".}

\item{...}{Additional arguments passed to the generic function.}
}
\value{
A data frame containing:
\itemize{
\item Single predictors (if any are specified in \code{object$keep})
\item Combined predictors based on variable pairs and interaction type
}
}
\description{
This function generates predictions by creating a dataset with single
and combined predictors based on the filtering results of a
multiDEGGs_filter model.
}
\details{
The function processes the filtering results in two steps:
\enumerate{
\item Selects single predictors from \code{newdata} based on variables
listed in \code{object$keep}
\item Adds combined predictors from paired variables in
\code{object$pairs}
}
}
