% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation.R
\name{data_generation}
\alias{data_generation}
\title{Generate data for simulations.}
\usage{
data_generation(
  K = 10,
  outlier_K = 1,
  simulation_no = c("MTL-1", "MTL-2"),
  h_w = 0.1,
  h_mu = 1,
  n = 50
)
}
\arguments{
\item{K}{the number of tasks (data sets). Default: 10}

\item{outlier_K}{the number of outlier tasks. Default: 1}

\item{simulation_no}{simulation number in Tian, Y., Weng, H., & Feng, Y. (2022)). Can be "MTL-1", "MTL-2". Default = "MTL-1".}

\item{h_w}{the value of h_w. Default: 0.1}

\item{h_mu}{the value of h_mu. Default: 1}

\item{n}{the sample size of each task. Can be either an positive integer or a vector of length \code{K}. If it is an integer, then the sample size of all tasks will be the same and equal to \code{n}. If it is a vector, then the k-th number will be the sample size of the k-th task. Default: 50.}
}
\value{
a list of two sub-lists "data" and "parameter". List "data" contains a list of design matrices \code{x}, a list of hidden labels \code{y}, and a vector of outlier task indices \code{outlier_index}. List "parameter" contains a vector \code{w} of mixture proportions, a matrix \code{mu1} of which each column is the GMM mean of the first cluster of each task, a matrix \code{mu2} of which each column is the GMM mean of the second cluster of each task, a matrix \code{beta} of which each column is the discriminant coefficient in each task, a list \code{Sigma} of covariance matrices for each task.
}
\description{
Generate data for simulations. All models used in Tian, Y., Weng, H., & Feng, Y. (2022)) are implemented.
}
\examples{
data_list <- data_generation(K = 5, outlier_K = 1, simulation_no = "MTL-1", h_w = 0.1,
h_mu = 1, n = 50)
}
\references{
Tian, Y., Weng, H., & Feng, Y. (2022). Unsupervised Multi-task and Transfer Learning on Gaussian Mixture Models. arXiv preprint arXiv:2209.15224.
}
\seealso{
\code{\link{mtlgmm}}, \code{\link{tlgmm}}, \code{\link{predict_gmm}}, \code{\link{initialize}}, \code{\link{alignment}}, \code{\link{alignment_swap}}, \code{\link{estimation_error}}, \code{\link{misclustering_error}}.
}
