% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msdStats.R
\name{msdStats}
\alias{msdStats}
\title{Main Mid Summer Drought Calculation Function}
\usage{
msdStats(x, dates, fcn)
}
\arguments{
\item{x}{Filtered xts data (from msdFilter)}

\item{dates}{Vector of Dates (from the msdDates function)}

\item{fcn}{Specify what values to be pulled from the function.
Options are 'duration', 'intensity', 'firstMaxValue', 'secondMaxValue', 'min', 'mindex'.}
}
\value{
SpatRaster or TimeSeries of Yearly data
}
\description{
This function calculates the different statistics of the mid summer drought from a Time Series.
The input must be in the form of daily data, with the first data point being January 1st of a respective year.
}
\examples{
data("timeseries")
ts <- timeseries
dates <- zoo::index(ts)
filteredData <- msdrought::msdFilter(ts, window = 31, quantity = 2)
keyDates <- msdDates(dates)
msdrought::msdStats(filteredData, keyDates, fcn = "duration")

}
